import {takeLatest} from 'redux-saga';
import {take, call, put, fork, cancel, select, race} from 'redux-saga/effects';
import {fetchList, fetchCates, fetchItem, updateItem, createItem} from '../services/product';
import {message} from 'antd';
import {watchIndex, watchShow, watchCreate, watchEdit} from './RESTful';

function* getList(query) {
    try {
        const {total, list} = yield call(fetchList, query);
        yield put({
            type: 'FETCH_PRODUCT_LIST_SUCCESS',
            total,
            items:list
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_PRODUCT_LIST_FAILED',
            err,
        });
    }
}

function* watchProductList() {
    while (true) {
        const {query} = yield take('FETCH_PRODUCT_LIST');
        yield fork(getList, query);
    }
}

function* getCates() {
    try {
        const cates = yield call(fetchCates);
        yield put({
            type: 'FETCH_PRODUCT_CATES_SUCCESS',
            cates
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_PRODUCT_CATES_FAILED',
            err,
        });
    }
}

function* watchProductCates() {
    yield takeLatest('FETCH_PRODUCT_CATES', getCates);
}


function* getItem(id) {
    try {
        const item = yield call(fetchItem, id);
        yield put({
            type: 'FETCH_PRODUCT_ITEM_SUCCESS',
            item
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_PRODUCT_ITEM_FAILED',
            err
        });
    }
}

function* watchProductItem() {
    while (true) {
        const {id} = yield take('FETCH_PRODUCT_ITEM');
        yield fork(getItem, id);
    }
}

function* editItem(item) {
    try {
        yield call(updateItem, item);
        message.success('保存成功!');
        yield put({
            type: 'UPDATE_PRODUCT_ITEM_SUCCESS',
            item
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'UPDATE_PRODUCT_ITEM_FAILED',
            err
        });
    }
}

function* watchEditProductItem() {
    while (true) {
        yield take('UPDATE_PRODUCT');
        yield put({
            type: 'UPDATE_PRODUCT_START'
        });
        const {data} = yield race({
            data: take('UPDATE_PRODUCT_ITEM'),
            canceled: take('CANCEL_UPDATE_PRODUCT')
        });

        if (data && data.item) {
            yield fork(editItem, data.item);
        }else{
            yield put({
                type: 'UPDATE_PRODUCT_END'
            });
        }
    }
}

function* addItem() {
    try {
        const item = yield call(createItem);
        yield put({
            type: 'CREATE_PRODUCT_ITEM_SUCCESS',
            item
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'CREATE_PRODUCT_ITEM_FAILED',
            err
        });
    }
}

function* watchAddItem() {
    yield takeLatest('CREATE_PRODUCT_ITEM', addItem);
}


export default function*() {
    // yield fork(watchProductList);
    yield fork(watchProductCates);
    // yield fork(watchProductItem);
    // yield fork(watchEditProductItem);
    yield fork(watchAddItem);
    const ID = 'PRODUCT';
    // yield fork(watchCreate(ID, createItem));
    yield fork(watchIndex(ID, fetchList));
    yield fork(watchShow(ID, fetchItem));
    yield fork(watchEdit(ID, updateItem));
}
