import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Form, Input, Button, Checkbox, message, Spin} from 'antd';
import {Link} from 'react-router';

@connect(state=>({
    loading: state.user.loading
}))
@Form.create()
export default class Login extends Component {

    static propTypes = {
        form: PropTypes.object,
        dispatch: PropTypes.func,

    };

    componentWillMount() {
        sessionStorage.clear();
    }

    handleSubmit = (e)=> {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        this.props.dispatch({
            ...data,
            replace: this.props.history.replace,
            type: 'LOGIN_REQUEST'
        });
    };

    render = ()=> {
        const {form:{getFieldProps}, loading} = this.props;
        const styles = require('./Login.less');
        const bg = require('./images/bg1.jpg');
        return (
            <Spin spinning={loading} tip="正在登录...">

                <div className={styles.normal}>
                    <div className={styles.content}>
                        <div className={styles['login-bg']} style={{backgroundImage: 'url(' + bg + ')'}}/>
                        <div className={styles['login-container']}>
                            <div>
                                <div>
                                    <h1>枢纽科技后台管理系统</h1>
                                    <Form inline onSubmit={this.handleSubmit.bind(this)}>
                                        <div>
                                            <Form.Item>
                                                <Input placeholder="请输入账户名" {...getFieldProps('username')} />
                                            </Form.Item>
                                            <Form.Item>
                                                <Input type="password"
                                                       placeholder="请输入密码" {...getFieldProps('password')} />
                                            </Form.Item>
                                        </div>
                                        <div>
                                            <Form.Item>
                                                <Checkbox {...getFieldProps('agreement')}>记住我</Checkbox>
                                            </Form.Item>
                                            <Button type="primary" htmlType="submit">登录</Button>
                                            <Link to="/register">
                                                <Button type="ghost">注册</Button>
                                            </Link>

                                        </div>
                                    </Form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </Spin>
        );
    }
}

