import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';
import FooterOperation from  '../../components/FooterOperation/FooterOperation';

import {formItemLayout, footerFormSubmitLayout, innerHTML} from '../../utils';

@connect(state=>({
    loading: state.announcement.loading,
    item: state.announcement.item,
    isEdit: state.announcement.isEdit
}))
@Form.create()
export default class EditItem extends Component {
    constructor() {
        super(...arguments);

    }


    componentDidMount() {
        const {params:{id}} = this.props;
        if (id) {
            this.fetchItem(id);
        }
    };

    componentWillReceiveProps(nextProps) {
        const {params:{id}, history} = this.props;
        const {item} = nextProps;
        if (!id && item && item.id) {
            history.replace('/announcement/' + item.id);
            return;
        }
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_ANNOUNCEMENT_ITEM',
            id
        });
    };

    handleSubmit(e) {
        e.preventDefault();
        const {form, dispatch, params:{id}, location:{query:{itemId}}} = this.props;
        const data = form.getFieldsValue();
        if (id) {
            data.id = id;
        } else {
            data.itemId = itemId;
        }
        console.log(data, id, data.id ? 'CREATE_ANNOUNCEMENT_ITEM' : 'UPDATE_ANNOUNCEMENT_ITEM');
        dispatch({
            type: data.id ? 'UPDATE_ANNOUNCEMENT_ITEM' : 'CREATE_ANNOUNCEMENT_ITEM',
            item: data
        });
    }

    render() {
        let {item, loading, form:{getFieldProps}, location:{query}, isEdit, params, dispatch} = this.props;

        const isCreate = !params.id;

        if (!params.id) {
            item = {
                status: 1
            };
            isEdit = true;
        }


        const breadcrumb = isCreate ? ['产品管理', '添加公告'] : ['产品管理', '公告详情'];

        const title = (query.title ? query.title + ' - ' : '') + (isCreate ? '添加公告' : ('公告详情' + (isEdit ? ' - 编辑' : '')) );

        const operation = (
            <HeaderOperation history={this.props.history}
                             buttons={DetailOperations('ANNOUNCEMENT', params.id, isEdit, dispatch)}/>
        );

        const header = (
            <MainHeader breadcrumb={breadcrumb} title={title}
                        operation={operation}
            />
        );

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        item &&
                        <Form className="main-form" horizontal onSubmit={this.handleSubmit.bind(this)}>
                            <Form.Item label="标题" {...formItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder="公告标题"
                                               {...getFieldProps('title', {
                                                   initialValue: item.title
                                               })}  />
                                        :
                                        item.title
                                }

                            </Form.Item>
                            <Form.Item label="内容" {...formItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder="公告内容" autosize={{minRows: 5}} type="textarea"
                                               {...getFieldProps('announcement', {
                                                   initialValue: item.announcement
                                               })}  />
                                        :
                                        <p style={{maxWidth: 500}} {...innerHTML(item.announcement, true)} />
                                }
                            </Form.Item>
                            <FooterOperation {...this.props} isEdit={isEdit} command="ANNOUNCEMENT"
                                             hasCancel={!isCreate}/>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}
