import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';

import {
    formatDateTime,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    remittanceAuditStatusToString,
    leftRightFormItemLayout,
    NULL
} from '../../utils';

@connect(state=>({
    loading: state.remittance.loading,
    audit: state.remittance.audit,
}))
@Form.create()
export default class PassItem extends Component {
    constructor() {
        super(...arguments);
        this.state = {
            priviewVisible: false,
            priviewImage: '',
            isEdit: false
        }
    }

    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_REMITTANCE_ITEM',
            id
        });
    };

    handleSubmit(status, e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.id = this.props.params.id;
        data.status = status;
        console.log(data);
        if (status == 9) {
            delete data.memo;
        }
        this.props.dispatch({
            type: 'PASS_REMITTANCE_ITEM',
            data
        });
    }

    render() {
        const {audit, loading, form:{getFieldProps}, location:{query}, params, dispatch} = this.props;

        let title = (audit && audit.itemShortTitle ? audit.itemShortTitle + ' - ' : '');

        const isEdit = audit && audit.status == 1 && this.state.isEdit;

        if (audit) {
            switch (audit.status) {
                case 1:
                    title += '报单审核详情';
                    break;
                case 5:
                    title += '审核失败';
                    break;
                case 9:
                    title += '审核成功';
            }
        } else {
            title += '报单审核详情';
        }


        const buttons = [{
            key: 'rollback',
            onClick: e=> {
                e.preventDefault();
                isEdit ?
                    this.setState({isEdit: !this.state.isEdit}) :
                    this.props.history.goBack();
            }
        }];

        if (audit && audit.status == 1) {
            buttons.unshift({
                key: 'edit',
                onClick: e=> {
                    e.preventDefault();
                    this.setState({isEdit: !this.state.isEdit})
                }
            });
        }

        const operation = (
            <HeaderOperation history={this.props.history} buttons={buttons}/>
        );

        const header = (<MainHeader breadcrumb={['审核管理', '报单审核', '审核详情']} title={title} operation={operation}/>);


        const imgProps = (src)=>({
            src: src + '!t',
            style: {maxWidth: 200, maxHeight: 160},
            onClick: e => {
                e.preventDefault();
                this.setState({
                    priviewVisible: true,
                    priviewImage: src
                });
            }
        });


        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        audit &&
                        <Form className="main-form" horizontal>
                            <Row style={{padding: '0 20px'}}>
                                <Col span="12">
                                    <Form.Item label="报单时间" {...leftRightFormItemLayout}>
                                        {audit.dateCreated && formatDateTime(audit.dateCreated) || '错误的时间'}
                                    </Form.Item>
                                    <Form.Item label="产品募集情况" {...leftRightFormItemLayout}>
                                        {'已募集:' + (audit.fundRaisedOver || NULL) + '、募集目标:' + (audit.fundRaisedTarget || NULL)}
                                    </Form.Item>
                                    <Form.Item label="预约姓名" {...leftRightFormItemLayout}>
                                        {audit.buyerName || NULL}
                                    </Form.Item>
                                    <Form.Item label="预约金额" {...leftRightFormItemLayout}>
                                        {audit.reservationAmount || NULL}
                                    </Form.Item>
                                    {
                                        isEdit ?
                                            <Form.Item label="实际入账金额"
                                                       help="实际入账金额，请核对打款凭条" {...leftRightFormItemLayout}>
                                                <Input placeholder="实际入账金额"
                                                       {...getFieldProps('remittanceAmount', {
                                                           initialValue: audit.remittanceAmount
                                                       })}  />
                                            </Form.Item>
                                            :
                                            <Form.Item label="实际入账金额"  {...leftRightFormItemLayout}>
                                                {audit.remittanceAmount || NULL}
                                            </Form.Item>
                                    }
                                    {
                                        isEdit ?
                                            <Form.Item label="投资人姓名"
                                                       help="真实的投资人姓名，请核对身份证照片上的姓名" {...leftRightFormItemLayout}>
                                                <Input placeholder="投资人姓名"
                                                       {...getFieldProps('realName', {
                                                           initialValue: audit.realName
                                                       })}  />
                                            </Form.Item>
                                            :
                                            <Form.Item label="投资人姓名" {...leftRightFormItemLayout}>
                                                {audit.realName || NULL}
                                            </Form.Item>
                                    }
                                    {
                                        isEdit ?
                                            <Form.Item label="投资人身份证号码"
                                                       help="真实的投资人身份证号码，请核对身份证照片上的号码" {...leftRightFormItemLayout}>
                                                <Input placeholder="投资人身份证号码"
                                                       {...getFieldProps('identityCardNumber', {
                                                           initialValue: audit.identityCardNumber
                                                       })}  />
                                            </Form.Item>
                                            :
                                            <Form.Item label="投资人身份证号码" {...leftRightFormItemLayout}>
                                                {audit.identityCardNumber || NULL}
                                            </Form.Item>
                                    }


                                    <Form.Item label="开户行" {...leftRightFormItemLayout}>
                                        {audit.bankBranch || NULL}
                                    </Form.Item>

                                    <Form.Item label="打款时间" {...leftRightFormItemLayout}>
                                        {audit.remittanceTime && formatDateTime(audit.remittanceTime) || '错误的时间'}
                                    </Form.Item>

                                    {
                                        isEdit &&
                                        <Form.Item label="拒绝理由" {...leftRightFormItemLayout}>
                                            <Input placeholder="拒绝理由"
                                                   {...getFieldProps('memo', {
                                                       initialValue: audit.memo
                                                   })}  />
                                        </Form.Item>
                                    }
                                    <Form.Item wrapperCol={{span: 16, offset: 6}} style={{marginTop: 30}}>
                                        {
                                            audit.status == 1 && (
                                                isEdit ?
                                                    <span>
                                                        <Button size="large" type="primary"
                                                                onClick={this.handleSubmit.bind(this, 9)}>
                                                            <Icon type="check-circle-o"/>通过
                                                        </Button>
                                                        <Button size="large" type="ghost"
                                                                onClick={this.handleSubmit.bind(this, 5)}
                                                                style={{margin: 'auto 1em'}}>
                                                            <Icon type="cross-circle-o"/>拒绝
                                                        </Button>
                                                    </span>
                                                    :
                                                    <Button type="primary"
                                                            style={{marginRight: '1em'}}
                                                            onClick={ e=> {
                                                                e.preventDefault();
                                                                this.setState({isEdit: !this.state.isEdit})
                                                            }}>
                                                        <Icon type="edit"/>审核
                                                    </Button>
                                            )
                                        }
                                        <Button onClick={e=> {
                                            e.preventDefault();
                                            isEdit ?
                                                this.setState({isEdit: !this.state.isEdit}) :
                                                this.props.history.goBack();
                                        }}>
                                            <Icon type="rollback"/>返回
                                        </Button>
                                        {
                                            audit.status == 9 &&
                                            <Button style={{marginLeft:'1em'}} type="ghost" onClick={e=>{
                                                e.stopPropagation();
                                                const iframe = document.createElement('iframe');
                                                iframe.src = '/zip/' + params.id + '.zip?id=' + params.id;
                                                document.body.appendChild(iframe);
                                                setTimeout(()=> {
                                                    document.body.removeChild(iframe);
                                                }, 1000);
                                            }}>下载</Button>
                                        }
                                    </Form.Item>
                                </Col>
                                <Col span="12">
                                    <Form.Item label="投资人身份证照片">
                                        {
                                            audit.identityCardFront ?
                                                <img {...imgProps(audit.identityCardFront)}/>
                                                :
                                                <p style={{color: '#f00'}}>
                                                    <Icon type="cross-circle-o" style={{marginRight: '.5em'}}/>
                                                    身份证正面照片未上传，请拒绝!
                                                </p>
                                        }
                                        {
                                            audit.identityCardBack ?
                                                <img {...imgProps(audit.identityCardBack)}/>
                                                :
                                                <p style={{color: '#f00'}}>
                                                    <Icon type="cross-circle-o" style={{marginRight: '.5em'}}/>
                                                    身份证反面照片未上传，请拒绝!
                                                </p>
                                        }

                                    </Form.Item>
                                    <Form.Item label="投资人银行卡照片">
                                        {
                                            audit.bankCardPic ?
                                                <img {...imgProps(audit.bankCardPic)}/>
                                                :
                                                <p style={{color: '#f00'}}>
                                                    <Icon type="cross-circle-o" style={{marginRight: '.5em'}}/>
                                                    银行卡照片未上传，请拒绝!
                                                </p>
                                        }
                                    </Form.Item>
                                    <Form.Item label="投资人打款凭条">
                                        {
                                            audit.remittanceReceipt ?
                                                <img {...imgProps(audit.remittanceReceipt)}/>
                                                :
                                                <p style={{color: '#f00'}}>
                                                    <Icon type="cross-circle-o" style={{marginRight: '.5em'}}/>
                                                    打款凭条照片未上传，请拒绝!
                                                </p>
                                        }

                                    </Form.Item>
                                    <Form.Item label="投资人签字页">
                                        {
                                            audit.signaturePages.length ?
                                                audit.signaturePages.map((img, index)=>
                                                    <img key={index} {...imgProps(img)}/>
                                                )
                                                :
                                                <p style={{color: '#f00'}}>
                                                    <Icon type="cross-circle-o" style={{marginRight: '.5em'}}/>
                                                    签字页照片未上传，请拒绝!
                                                </p>
                                        }
                                    </Form.Item>
                                </Col>
                            </Row>
                            <Modal className="img-priview-dialog" footer={null}
                                   visible={this.state.priviewVisible}
                                   onCancel={()=>this.setState({priviewVisible: false})}>
                                <img src={this.state.priviewImage}/>
                            </Modal>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}
