import React, {Component, PropTypes} from 'react';
import {Button, Icon, Popconfirm, Menu, Row, Col, Popover, Tooltip} from 'antd';
import {connect} from 'react-redux';
import {Link} from 'react-router';

@connect(state=>({
    user: state.user
}))
export default class HeaderOperation extends Component {

    static propTypes = {
        dispatch: PropTypes.func,
        history: PropTypes.object,
        user: PropTypes.object,
        buttons: PropTypes.array,
    };

    componentWillReceiveProps(nextProps) {
        if (nextProps.removed) {
            this.props.history.goBack();
        }
    }


    render() {

        const {history, user, buttons = []}  = this.props;

        const defaultButtons = {
            edit: {
                title: '编辑',
                icon: 'edit',
                onClick: ()=> {
                    console.error('没有实现的编辑操作');
                }
            },
            remove: {
                title: '删除',
                icon: 'cross-circle-o',
                confirm: '',
                onConfirm: ()=> {
                    console.error('没有实现的删除操作');
                }
            },
            cancel: {
                title: '取消',
                icon: 'rollback',
                onClick: ()=> {
                    console.error('没有实现的取消操作');
                }
            },
            rollback: {
                title: '返回',
                icon: 'rollback',
                onClick: (e)=> {
                    e.preventDefault();
                    history.goBack();
                }
            },
            add: {
                title: '添加',
                icon: 'plus',
                onClick: ()=> {
                    console.error('没有实现的添加操作');
                }
            },
            filter: {
                title: '筛选',
                icon: 'filter',
                onClick: ()=> {
                    console.error('没有实现的筛选操作');
                }
            }
        };

        const operations = buttons.length ? (
            <Button.Group>
                {
                    buttons.map(button=> {
                        const props = {...defaultButtons[button.key], ...button};
                        const title = props.title;

                        delete props.title;

                        if (props.link) {
                            const icon = props.icon;
                            const link = props.link;
                            delete props.icon;
                            delete props.link;
                            return (
                                <Tooltip title={title} key={props.key + 'tooltip'}>
                                    <Button type="ghost" {...props} >
                                        <Link to={link}>
                                            <Icon type={icon}/>
                                        </Link>
                                    </Button>
                                </Tooltip>
                            );
                        }
                        const btn = (
                            <Tooltip title={title} key={props.key + 'tooltip'}>
                                <Button type="ghost" {...props} />
                            </Tooltip>
                        );
                        if (props.onConfirm) {
                            return (
                                <Popconfirm title={props.confirm || "确定要删除吗？"}
                                            onConfirm={props.onConfirm}>
                                    {btn}
                                </Popconfirm>
                            );
                        }
                        return btn;
                    })
                }
            </Button.Group>
        ) : null;

        const handleExit = (e)=> {
            e.preventDefault();
            this.props.dispatch({
                type: 'LOGIN_REQUEST',
                replace: this.props.history.replace
            });
            this.props.dispatch({
                type: 'LOGOUT'
            });
        };

        const userOperations = user ? (
            <ul>
                <li><a href="javascript:void('退出');" onClick={handleExit}>退出</a></li>
                <li><Link to="/my/modifyPassword">修改密码</Link></li>
                <li><Link to={'/my/' + user.id}>个人信息</Link></li>
            </ul>
        ) : null;


        return (
            <div style={{textAlign: 'right'}}>
                {operations}
                {
                    userOperations &&
                    <Popover content={userOperations}>
                        <Button type="ghost" style={{marginLeft: '2em'}}>
                            <Icon type="user"/>{user.username}
                        </Button>
                    </Popover>
                }
            </div>
        );
    }
}


export function DetailOperations(command, id, isEdit, dispatch) {
    const buttons = [];
    if (id) {
        !isEdit && buttons.push({
            key: 'edit',
            onClick: (e)=> {
                e.preventDefault();
                dispatch({type: 'UPDATE_' + command});
            }
        });
        isEdit && buttons.push({
            key: 'cancel',
            onClick: (e)=> {
                e.preventDefault();
                dispatch({type: 'CANCEL_UPDATE_' + command});
            }
        });
    }
    (!isEdit || !id) && buttons.push({
        key: 'rollback',
    });
    return buttons;
}
