import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';
import FooterOperation from '../../components/FooterOperation/FooterOperation';

import {
    formatDateTime,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    remittanceAuditStatusToString,
    leftRightFormItemLayout,
    NULL
} from '../../utils';

@connect(state=>({
    loading: state.authInfo.loading,
    audit: state.authInfo.item,
    isEdit: state.authInfo.isEdit
}))
@Form.create()
export default class PassItem extends Component {
    constructor() {
        super(...arguments);
        this.state = {
            priviewVisible: false,
            priviewImage: '',
        }
    }

    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_AUTHINFO',
            data:{id}
        });
    };

    handleSubmit(status, e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.id = this.props.params.id;
        data.status = status;
        console.log(data);
        if (status == 9) {
            delete data.memo;
        }
        this.props.dispatch({
            type: 'EDIT_AUTHINFO_SUBMIT',
            data
        });
    }

    render() {
        const {audit, loading, form:{getFieldProps}, location:{query}, params, dispatch, history} = this.props;

        let title = (audit && audit.realName ? audit.realName + ' - ' : '');

        const isEdit = audit && audit.status == 1 && this.props.isEdit;

        const isPassed = audit && audit.status != 1 ;

        if (audit) {
            switch (audit.status) {
                case 1:
                    title += '身份认证审核详情' + (isEdit? ' - 审核中': '');
                    break;
                case 5:
                    title += '审核失败';
                    break;
                case 9:
                    title += '审核成功';
            }
        } else {
            title += '身份认证审核详情';
        }


        const buttons = [{
            key: 'rollback',
            onClick: e=> {
                e.preventDefault();
                isEdit ?
                    dispatch({type:'EDIT_AUTHINFO_CANCEL'})
                    :
                    history.goBack();
            }
        }];

        if(audit && audit.status == 1 && !isEdit){
            buttons.unshift({
                key:'edit',
                onClick:e=> {
                    e.preventDefault();
                    dispatch({type:'EDIT_AUTHINFO_START'})
                }
            });
        }

        const operation = (
            <HeaderOperation history={this.props.history}
                             buttons={buttons}/>
        );

        const header = (<MainHeader breadcrumb={['审核管理', '身份认证审核', '审核详情']} title={title} operation={operation}/>);


        const imgProps = (src)=>({
            src: src + '!t',
            style: {maxWidth: 200, maxHeight: 160},
            onClick: e => {
                e.preventDefault();
                this.setState({
                    priviewVisible: true,
                    priviewImage: src
                });
            }
        });


        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        audit &&
                        <Form className="main-form" horizontal>
                            <Row style={{padding: '0 20px'}}>
                                <Col span="12">
                                    <Form.Item label="用户ID" {...leftRightFormItemLayout}>
                                        {audit.userId || NULL}
                                    </Form.Item>
                                    <Form.Item label="用户名" {...leftRightFormItemLayout}>
                                        {audit.realName || NULL}
                                    </Form.Item>
                                    <Form.Item label="昵称" {...leftRightFormItemLayout}>
                                        {audit.nick || NULL}
                                    </Form.Item>
                                    <Form.Item label="手机号" {...leftRightFormItemLayout}>
                                        {audit.mobile || NULL}
                                    </Form.Item>
                                    {
                                        audit.status == 5 ?
                                            <Form.Item label="拒绝理由" {...leftRightFormItemLayout}>
                                                { audit.memo || NULL }
                                            </Form.Item>
                                            :
                                            (
                                                audit.status == 1 && isEdit &&
                                                <Form.Item label="拒绝理由" {...leftRightFormItemLayout}>
                                                    <Input placeholder="拒绝理由"  type="textarea"
                                                           autosize
                                                           {...getFieldProps('memo', {
                                                               initialValue: ''
                                                           })}  />
                                                </Form.Item>
                                            )
                                    }
                                    <FooterOperation {...this.props} isEdit={isEdit} command="AUTHINFO" isPass={true}
                                                     isPassed={isPassed}
                                                     pass={this.handleSubmit.bind(this, 9)}
                                                     unPass={this.handleSubmit.bind(this, 5)}
                                                     hasCancel={true}/>

                                </Col>
                                <Col span="12">
                                    <Form.Item label="身份认证照片">
                                        {
                                            audit.authPic ?
                                                <img {...imgProps(audit.authPic)}/>
                                                :
                                                <p style={{color: '#f00'}}>
                                                    <Icon type="cross-circle-o" style={{marginRight: '.5em'}}/>
                                                    身份认证照片未上传，请拒绝!
                                                </p>
                                        }
                                    </Form.Item>
                                </Col>
                            </Row>
                            <Modal className="img-priview-dialog" footer={null}
                                   visible={this.state.priviewVisible}
                                   onCancel={()=>this.setState({priviewVisible: false})}>
                                <img src={this.state.priviewImage}/>
                            </Modal>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}
