import React, {Component, PropTypes} from 'react';
import {Link} from 'react-router';
import {connect} from 'react-redux';
import {Menu, Icon} from 'antd';

const SubMenu = Menu.SubMenu;
const MenuItemGroup = Menu.ItemGroup;

@connect(state=>({
    user: state.user
}))
export default class App extends Component {
    static propTypes = {
        children: PropTypes.object.isRequired,
    };

    static contextTypes = {
        store: PropTypes.object.isRequired
    };

    render() {
        const styles = require('./App.less');
        const menu = [
            {
                id: 'business',
                title: '业务管理',
                icon: 'mail',
                items: [
                    {
                        title: '产品管理',
                        items: [
                            {
                                to: '/products',
                                cn: '产品列表',
                                en: 'Products'
                            }, {
                                to: '/products/create',
                                cn: '添加产品',
                                en: 'Add Products'
                            }
                        ]
                    }, {
                        title: '订单管理',
                        items: [
                            {
                                to: '/trades',
                                cn: '订单列表',
                                en: 'Trades'
                            }
                        ]
                    }, {
                        title: '审核管理',
                        items: [
                            {
                                to: '/remittance/audits',
                                cn: '报单审核',
                                en: 'Remittance Audits'
                            }, {
                                to: '/withdraw/audits',
                                cn: '提现审核',
                                en: 'Withdraw Money'
                            }, {
                                to: '/authInfo/audits',
                                cn: '身份认证审核',
                                en: 'Auth Audits'
                            }
                        ]
                    }, {
                        title: '消息管理',
                        items: [
                            {
                                to: '/customMessages',
                                cn: '消息列表',
                                en: 'Messages'
                            }, {
                                to: '/customMessages/create',
                                cn: '推送消息',
                                en: 'Send Message'
                            }
                        ]
                    }, {
                        title:'Banner管理',
                        items:[
                            {
                                to: '/banners',
                                cn: 'Banner列表',
                                en: 'Banners'
                            }
                        ]
                    }
                ]
            }, {
                id: 'base',
                title: '基础功能',
                icon: 'folder',
                items: [
                    {
                        title: '文件管理',
                        items: [
                            {
                                to: '/upload',
                                cn: '图片上传',
                                en: 'Upload Images'
                            }
                        ]
                    }
                ]
            }];

        const {user} = this.props;

        if (user && user.authorities && user.authorities['ROLE_ADMIN']) {
            menu.push({
                id: 'admin',
                title: '管理员',
                icon: 'folder',
                items: [
                    {
                        title: '用户管理',
                        items: [
                            {
                                to: '/admin/users',
                                cn: '用户列表',
                                en: 'Users'
                            }
                        ]
                    }, {
                        title: '权限管理',
                        items: [
                            {
                                to: '/admin/resources',
                                cn: '权限资源列表',
                                en: ''
                            }, {
                                to: '/admin/authorities',
                                cn: '角色列表',
                                en: 'Authorities'
                            }
                        ]
                    }
                ]
            })
        }

        menu.push({
            id: 'setting',
            title: '设置',
            icon: 'setting',
            items: [
                {
                    title: '个人信息',
                    items: [
                        {
                            to: '/my/modifyPassword',
                            cn: '修改密码',
                            en: 'Modify Password'
                        }, {
                            to: '/my/' + (user && user.id || ''),
                            cn: '个人资料',
                            en: 'Profile setting'
                        }, {
                            onClick: (e)=> {
                                e.preventDefault();
                                this.props.dispatch({
                                    type: 'LOGIN_REQUEST',
                                    replace: this.props.history.replace
                                });
                                this.props.dispatch({
                                    type: 'LOGOUT'
                                });
                            },
                            cn: '退出',
                            en: 'Exit System'
                        }
                    ]
                }
            ]
        });

        const logo = require('./images/logo.png');

        const openKey = '';

        return (
            <div className={styles.content}>
                <div className={styles.side}>
                    <header>
                        <img className="page-logo" src={logo} title="枢纽科技" alt="枢纽科技"/>
                    </header>
                    <section>
                        <Menu mode="inline" defaultOpenKeys={['sub1']}>
                            {user && user.token &&
                            menu.map((submenu, si)=>
                                <SubMenu key={'submenu' + si} title={
                                    <span><Icon type={submenu.icon}/><span>{submenu.title}</span></span>
                                }>
                                    {submenu.items.map((menus, mi)=>
                                        <MenuItemGroup key={'menu-item-group-' + si + '-' + mi} title={menus.title}>
                                            {menus.items.map((item, ii)=>
                                                <Menu.Item key={[si, mi, ii].join('-')}>
                                                    <MenuItemContent {...item}/>
                                                </Menu.Item>
                                            )}
                                        </MenuItemGroup>
                                    )}
                                </SubMenu>
                            )}
                        </Menu>
                    </section>
                    <footer>
                        杭州枢纽科技有限公司
                    </footer>
                </div>
                <div className={styles.main}>
                    {user && user.token && this.props.children}
                </div>
            </div>
        );
    }
}

class MenuItemContent extends Component {
    static propType = {
        to: PropTypes.string,
        cn: PropTypes.string,
        en: PropTypes.string,
    }

    render() {
        const {to, cn, en, onClick} = this.props;
        return (
            onClick ?
                <a href={"javascript:void('" + cn + "');"} onClick={onClick}>
                    <span>
                        <span className="cn">{cn}</span>
                        <span className="en">{en}</span>
                    </span>
                </a>
                :
                <Link to={to}>
                    <span>
                        <span className="cn">{cn}</span>
                        <span className="en">{en}</span>
                    </span>
                </Link>
        );
    }
}





