import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';
import FooterOperation from '../FooterOperation/FooterOperation';


import {arrayRemoveIndex, NULL, UUID, formItemLayout, smallFormItemLayout, footerFormSubmitLayout} from '../../utils';


export function YongjingTransform(arr) {
    return arr.map(item=>({
        ...item,
        key: UUID()
    }));
}

export function CreateYongjing() {
    return {key: UUID(), result: {}};
};

@Form.create()
export default class ShouyiYongjingForm extends Component {


    constructor(props, context) {
        super(props, context);

        this.state = {
            yongjing: []
        };
    }

    componentDidMount() {
        this.analysisYongjing(this.props);
    }

    componentWillReceiveProps(nextProps) {
        if (nextProps.isEdit !== this.props.isEdit) {
            this.analysisYongjing(nextProps);
        }
    }

    analysisYongjing(props) {
        if (props.product && props.product.commissionAlg) {
            this.setState({
                yongjing: YongjingTransform(props.product.commissionAlg)
            });
        }
    }

    static propsType = {
        product: PropTypes.object,
        user: PropTypes.object,
        dispatch: PropTypes.func
    };

    // componentWillReceiveProps(nextProps) {
    //     if (nextProps && nextProps.product && nextProps.product.commissionAlg) {
    //         if (nextProps.product.commissionAlg.length != this.props.product.commissionAlg.length) {
    //             this.setState({
    //                 yongjing: YongjingTransform(nextProps.product.commissionAlg)
    //             });
    //         }
    //
    //     }
    // }

    /**
     * 添加佣金算法
     * @param e
     */
    handleAddYongjing(e) {
        e.preventDefault();
        let yongjing = [].concat(this.state.yongjing);
        yongjing.push(CreateYongjing());
        this.setState({yongjing: yongjing});
    }

    /**
     * 删除佣金算法
     * @param index
     * @param e
     */
    handleRemoveYongjin(index, e) {
        e.preventDefault();
        const yongjing = arrayRemoveIndex(this.state.yongjing, index);
        console.log(yongjing);
        this.setState({yongjing: yongjing});
    }

    handleSubmit(e) {
        e.preventDefault();
        const formData = this.props.form.getFieldsValue();

        const commissionAlg = [];
        const data = {
            id: this.props.product.id
        };
        Object.keys(formData).forEach(key=> {
            if (/^[\d]+$/g.test(key)) {
                const d = formData[key];
                const dr = {
                    min: (typeof d.min === 'undefined') ? '' : String(d.min).trim(),
                    max: (typeof d.max === 'undefined') ? '' : String(d.max).trim(),
                    result: {
                        yj: String(d.yj).trim(),
                        sy: String(d.sy).trim()
                    }
                };
                if(!dr.min){
                    delete dr.min;
                }
                if(!dr.max){
                    delete dr.max;
                }
                if(!dr.result.yj){
                    delete dr.result.yj;
                }
                if(!dr.result.sy){
                    delete dr.result.sy;
                }
                commissionAlg.push(dr);
            } else {
                data[key] = formData[key];
            }
        });
        data.commissionAlg = JSON.stringify(commissionAlg);

        console.log(formData, data);

        this.props.dispatch({
            type: this.props.isCreate ? 'UPDATE_PRODUCT' : 'EDIT_PRODUCT_SUBMIT',
            data
        });

    }

    render() {

        const {form:{getFieldProps}, product, loading, isEdit, isCreate} = this.props;

        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                    <Form.Item label="佣金结算方式" help={isEdit && "例如: 打款结佣、成立结佣"} {...smallFormItemLayout}>
                        {
                            isEdit ?
                                <Input placeholder="佣金结算方式"
                                    {...getFieldProps('settlement', {
                                        initialValue: product.settlement
                                    })}
                                />
                                :
                            product.settlement || NULL
                        }

                    </Form.Item>
                    <Form.Item label="产品的预期收益" help={isEdit && "浮动或百分比"} {...smallFormItemLayout}>
                        {
                            isEdit ?
                                <Input placeholder="产品的预期收益"
                                    {...getFieldProps('productProspectiveReturn', {
                                        initialValue: product.productProspectiveReturn
                                    })}
                                />
                                :
                            product.productProspectiveReturn || NULL
                        }

                    </Form.Item>
                    <Form.Item label="佣金算法" {...formItemLayout}>
                        {
                            isEdit ?
                                <div>
                                    <Input.Group>
                                        <Col span="5" className="tac">最小投资额</Col>
                                        <Col span="5" className="tac">最大投资额</Col>
                                        <Col span="5" className="tac">收益</Col>
                                        <Col span="5" className="tac">佣金</Col>
                                    </Input.Group>
                                    {
                                        this.state.yongjing.map((item, index)=>
                                            <div key={item.key}>
                                                <Input.Group>
                                                    <Col span="5">
                                                        <Input {...getFieldProps(item.key + '.min', {initialValue: item.min})} />
                                                    </Col>
                                                    <Col span="5">
                                                        <Input {...getFieldProps(item.key + '.max', {initialValue: item.max})}/>
                                                    </Col>
                                                    <Col span="5">
                                                        <Input {...getFieldProps(item.key + '.sy', {initialValue: item.result && item.result.sy})}/>
                                                    </Col>
                                                    <Col span="5">
                                                        <Input {...getFieldProps(item.key + '.yj', {initialValue: item.result && item.result.yj})}/>
                                                    </Col>
                                                    <Col span="4">
                                                        <Icon type="cross"
                                                              onClick={this.handleRemoveYongjin.bind(this, index)}/>
                                                    </Col>
                                                </Input.Group>
                                            </div>
                                        )
                                    }
                                </div>
                                :
                                (
                                    this.state.yongjing.length ?
                                        <table className="data-grid tac">
                                            <thead>
                                            <tr>
                                                <th className="tac">最小投资额</th>
                                                <th className="tac">最大投资额</th>
                                                <th className="tac">收益</th>
                                                <th className="tac">佣金</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            {

                                                this.state.yongjing.map((item, index)=>
                                                    <tr key={item.key}>
                                                        <td>{item.min}</td>
                                                        <td>{item.max}</td>
                                                        <td>{item.result && item.result.sy}</td>
                                                        <td>{item.result && item.result.yj}</td>
                                                    </tr>
                                                )
                                            }
                                            </tbody>
                                        </table>
                                        :
                                        NULL
                                )
                        }
                    </Form.Item>
                    <FooterOperation {...this.props}
                                     layout={{wrapperCol:{span: 16, offset: 6}}}
                                     command="PRODUCT"
                                     hasCancel={!isCreate}
                                     beforeButtons={
                                         isEdit ?
                                             <Button size="large" onClick={this.handleAddYongjing.bind(this)}
                                                           style={{marginRight:'1em'}}>
                                                <Icon type="plus"/>添加
                                             </Button>
                                             :null
                                     } />
                </Form>
            </Spin>
        );
    }
}

/*
 <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
 {
 isEdit ?
 <span>
 <Button size="large" onClick={this.handleAddYongjing.bind(this)}
 style={{marginRight:'1em'}}>
 <Icon type="plus"/>添加
 </Button>
 <Button size="large" type="primary" htmlType="submit" loading={loading}>
 <Icon type="save"/>保存
 </Button>
 </span>
 :
 <Button type="primary" onClick={e=>{
 e.preventDefault();
 this.props.dispatch({
 type:'UPDATE_PRODUCT'
 });
 }}>
 <Icon type="edit"/>编辑
 </Button>
 }
 {
 !this.props.isCreate &&
 <Button onClick={e=>{
 e.preventDefault();
 isEdit ?
 this.props.dispatch({
 type: 'CANCEL_UPDATE_PRODUCT'
 }) :
 this.props.history.goBack();
 }}
 style={{marginLeft:'1em'}}>
 <Icon type="rollback"/>
 {isEdit ? '取消' : '返回'}
 </Button>
 }
 </Form.Item>
 */
