import React, {Component, PropTypes} from 'react';

import styles from './Layout.less';

export default function ({children, header, footer, contentClassName}) {
    return (
        <section className={styles.layout}>
            {header}
            <div className={[styles.content, contentClassName].join(' ')}>
                {children}
            </div>
            {footer}
        </section>
    );
}

//
// export default class Layout extends Component {
//     render() {
//         const {children, contentClassName, header, footer} = this.props;
//         const styles = require('./Layout.less');
//
//         return (
//             <section className={styles.layout}>
//                 {header}
//                 <div className={[styles.content, contentClassName].join(' ')}>
//                     {children}
//                 </div>
//                 {footer}
//             </section>
//         );
//
//     }
// }
