import React, {Component, PropTypes} from 'react';
import {Button, Icon, Form} from 'antd';

import {footerFormSubmitLayout} from '../../utils';

export default class FooterOperation extends Component {

    static propTypes = {
        isEdit: PropTypes.bool,
        isPass: PropTypes.bool,
        isPassed: PropTypes.bool,
        pass: PropTypes.func,
        unPass: PropTypes.func,
        command: PropTypes.string,
        dispatch: PropTypes.func,
        history: PropTypes.object,
        layout: PropTypes.object,
        beforeButtons: PropTypes.node,
        afterButtons: PropTypes.node
    };

    render() {
        const {isEdit, hasCancel = true, command, dispatch, history, loading, layout, beforeButtons, afterButtons, isPass, pass, unPass, isPassed} = this.props;
        const EDIT_COMMAND = 'EDIT_' + command + '_START';
        const EDIT_COMMAND_CANCEL = 'EDIT_' + command + '_CANCEL';
        const handleEditBtnClick = e => {
            e.preventDefault();
            dispatch({
                type: EDIT_COMMAND
            });
        };
        const handleRollbackBtnClick = e => {
            e.preventDefault();
            isEdit ? dispatch({type: EDIT_COMMAND_CANCEL}) : history.goBack();
        };
        return (
            <Form.Item {...footerFormSubmitLayout} {...layout} style={{marginTop: 30}}>
                {beforeButtons}
                {
                    isPass ?
                        (
                            isPassed ?
                                null:
                            isEdit ?
                                (
                                    <span>
                                        <Button size="large" type="primary"
                                                onClick={pass}>
                                            <Icon type="check-circle-o"/>通过
                                        </Button>
                                        <Button size="large" type="ghost"
                                                onClick={unPass}
                                                style={{marginLeft: '1em'}}>
                                            <Icon type="cross-circle-o"/>拒绝
                                        </Button>
                                    </span>
                                )
                                :
                                (<Button type="primary"
                                         onClick={handleEditBtnClick}>
                                    <Icon type="edit"/>审核
                                </Button>)
                        )
                        : (
                        isEdit ?
                            <Button type="primary" htmlType="submit" loading={loading}>
                                <Icon type="save"/>保存
                            </Button>
                            :
                            <Button type="primary" onClick={handleEditBtnClick}>
                                <Icon type="edit"/>编辑
                            </Button>
                    )
                }
                {
                    hasCancel &&
                    <Button onClick={handleRollbackBtnClick} style={{marginLeft: '1em'}}>
                        <Icon type="rollback"/>{isEdit ? '取消' : '返回'}
                    </Button>
                }
                {afterButtons}
            </Form.Item>
        );
    }
}
