import xFetch from './xFetch';
import {serialize} from '../utils';

export async function fetchList(query) {
    const data = {...query};
    delete  data.title;
    return xFetch('/api/announcements' + '?' + serialize({s:30, ...data}));
}

export async function fetchItem(id) {
    return xFetch('/api/announcements/' + id);
}

export async function createItem(item) {
    return xFetch('/api/announcements', {
        method: 'POST',
        body: serialize(item)
    });
}

export async function updateItem(item) {
    return xFetch('/api/announcements/'+item.id, {
        method: 'PUT',
        body: serialize(item)
    });
}
