import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon, Button, Switch, Form} from 'antd';
import {serialize, formatDateTime, productStatusToString, footerFormSubmitLayout} from '../../utils';
import {Link} from 'react-router';
import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation from '../../components/HeaderOperation/HeaderOperation';


@connect(state=>({
    items: state.announcement.items,
    loading: state.announcement.loading,
    total: state.announcement.total,
}))
export default class List extends Component {

    constructor(props, context) {
        super(props, context);
        this.state = {
            filterVisible: false
        }
    }

    componentDidMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(query) {
        this.props.dispatch({
            type: 'FETCH_ANNOUNCEMENT_LIST',
            query
        });
    };



    handleFilterVisible() {

    }

    render() {

        const {total, items, loading, history, location:{pathname, query}} = this.props;

        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 30,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            showTotal: total => `共 ${total} 条`,
            pageSizeOptions: ['10', '30', '50', '100'],
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                history.replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current)=> {
                console.log('Current: ', current);
                query.p = current;
                history.replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };

        const columns = [
            {
                title: 'ID',
                dataIndex: 'id',
                key: 'id',
                width: 60
            }, {
                title: '标题',
                dataIndex: 'title',
                key: 'title',
                width: 200,
            }, {
                title: '内容',
                dataIndex: 'announcement',
                key: 'announcement',
                width: 200,
                render: (announcement, record)=>(
                    <span title={announcement}>
                        {announcement && (announcement.length > 20 ? announcement.substr(0, 20) + '...' : announcement)}
                    </span>
                )
            }, {
                title: '创建时间',
                dataIndex: 'dateCreated',
                key: 'dateCreated',
                width: 150,
                className: 'tac',
                render: (dateCreated, record)=>(
                    <span>
                        {dateCreated && formatDateTime(dateCreated)}
                    </span>
                )
            }, {
                title: '状态',
                dataIndex: 'status',
                key: 'status',
                width: 120,
                className: 'tac',
                render: (text, record)=>(
                    <span onClick={e=> {
                        e.stopPropagation();
                        e.preventDefault();
                    }}>
                        <Switch checkedChildren="开" unCheckedChildren="关" defaultChecked={record.status}
                                onChange={checked=> {
                                    this.props.dispatch({
                                        type: 'UPDATE_ANNOUNCEMENT_ITEM',
                                        item: {
                                            id: record.id,
                                            status: checked ? 1 : 0
                                        }
                                    })
                                }}
                        />
                    </span>
                )
            }
        ];

        const buttons = [{
            key: 'add',
            link: '/announcement/create?itemId=' + query.itemId + '&title=' + query.title,
            onClick: ()=> {}
        }, {
            key: 'filter',
        }, {
            key: 'rollback'
        }];

        const operation = (
            <HeaderOperation history={history} buttons={buttons}/>
        );

        const header = (
            <MainHeader breadcrumb={['产品管理', '产品详情', '公告列表']}
                        title={(query.title ? query.title + ' - ' : '') + '公告列表'}
                        operation={operation}
            />
        );

        return (
            <Layout header={header} >
                <Table className="list-table" columns={columns}
                       dataSource={Array.isArray(items) ? items : []}
                       loading={loading}
                       pagination={pagination}
                       scroll={{y: window.innerHeight - (this.state.filterVisible ? 203 : 150)}}
                       onRowClick={({id})=> {
                           history.push('/announcement/' + id);
                       }}
                />
            </Layout>
        );
    }
}
