import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

import {
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    userStatusToString,
    formatDateTime,
    NULL
} from '../../utils';

@connect(state=>({
    loading: state.user.loading,
    item: state.user.item,
}))
@Form.create()
export default class EditItem extends Component {
    constructor() {
        super(...arguments);
        this.state = {
            isEdit: false
        }
    }


    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_USER_ITEM',
            id
        });
    };

    handleSubmit(status, e) {
        e.preventDefault();
        let data = {};
        if (status == 1 || status == 0) {
            data.status = status;
        } else {
            data = this.props.form.getFieldsValue();
        }
        data.id = this.props.params.id;
        console.log(data);
        this.props.dispatch({
            type: 'UPDATE_USER_ITEM',
            data
        });
    }

    render() {
        const {item, loading, form:{getFieldProps}, location:{query}} = this.props;

        const {isEdit} = this.state;

        const operation = (
            <div style={{textAlign:'right'}}>
                <Button.Group>

                    <Button type="ghost" onClick={e=>{e.preventDefault(); this.props.history.goBack();}}>
                        <Icon type="rollback"/>
                    </Button>
                </Button.Group>
            </div>
        );

        const header = (
            <MainHeader breadcrumb={['用户管理', '用户详情']}
                        title={(query && query.title ? query.title + ' - ' : '') + '用户详情'}
                        operation={operation}
            />
        );

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        item &&
                        <Form className="main-form" horizontal>
                            <Form.Item label="用户名" {...smallFormItemLayout}>
                                { item.username }
                            </Form.Item>
                            <Form.Item label="状态" {...smallFormItemLayout}>
                                {userStatusToString(item.status)}
                            </Form.Item>
                            <Form.Item label="昵称" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input {...getFieldProps('nick', {initialValue: item.nick})} />
                                        :
                                        item.nick || NULL
                                }
                            </Form.Item>
                            <Form.Item label="E-mail" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input {...getFieldProps('email', {initialValue: item.email})} />
                                        :
                                        item.email || NULL
                                }
                            </Form.Item>
                            <Form.Item label="手机号" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input {...getFieldProps('mobile', {initialValue: item.mobile})} />
                                        :
                                        item.mobile || NULL
                                }
                            </Form.Item>
                            <Form.Item label="注册时间" {...smallFormItemLayout}>
                                {item.dateCreated && formatDateTime(item.dateCreated)}
                            </Form.Item>
                            <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                {
                                    isEdit ?
                                        <Button type="primary" onClick={this.handleSubmit.bind(this, -1)}
                                                loading={loading}>
                                            <Icon type="save"/>修改
                                        </Button>
                                        :
                                        item.status ?
                                            <Button type="primary" onClick={this.handleSubmit.bind(this, 0)}
                                                    loading={loading}>
                                                <Icon type="save"/>禁用
                                            </Button>
                                            :
                                            <Button type="primary" onClick={this.handleSubmit.bind(this, 1)}
                                                    loading={loading}>
                                                <Icon type="save"/>激活
                                            </Button>
                                }
                                <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                        style={{marginLeft:'1em'}}>
                                    <Icon type="rollback"/>返回
                                </Button>
                            </Form.Item>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}

// <Button type="ghost" onClick={e=>{e.preventDefault(); this.setState({isEdit: !this.state.isEdit})}}>
//     <Icon type="edit"/>
// </Button>
