// import {handleActions} from 'redux-actions';
// import {combineReducer} from 'redux';
//
// const initState = {
//     items: [],
//     loading: false,
// };
//
// const trade = handleActions({
//     ['INIT_TRADE'](){
//         return {...initState};
//     },
//     ['FETCH_TRADE_LIST'](state) {
//         return {...state, loading: true,};
//     },
//     ['FETCH_TRADE_LIST_SUCCESS'](state, action) {
//         return {...state, loading: false, items: action.items, total: action.total};
//     },
//     ['FETCH_TRADE_LIST_FAILED'](state, action) {
//         return {...state, err: action.err, loading: false, items:[], total:0};
//     },
//     ['FETCH_TRADE_ITEM'](state){
//         return {...state, loading: true}
//     },
//     ['FETCH_TRADE_ITEM_SUCCESS'](state, action){
//         return {...state, loading: false, item: action.item}
//     },
//     ['FETCH_TRADE_ITEM_FAILED'](state, action){
//         return {...state, err: action.err, loading: false, item:null}
//     },
//     ['CREATE_TRADE_ITEM'](state){
//         return {...state, loading: true}
//     },
//     ['CREATE_TRADE_ITEM_SUCCESS'](state, action){
//         return {...state, loading: false, item: action.item, createSuccess: true}
//     },
//     ['CREATE_TRADE_ITEM_FAILED'](state, action){
//         return {...state, err: action.err, loading: false}
//     },
//     ['SETTLEMENT_TRADE_ITEM'](state){
//         return {...state, loading: true};
//     },
//     ['SETTLEMENT_TRADE_ITEM_SUCCESS'](state, action){
//         return {...state, loading: false, item: {...state.item, ...action.item}};
//     },
//     ['SETTLEMENT_TRADE_ITEM_FAILED'](state, action){
//         return {...state, err: action.err, loading: false};
//     },
//
//     ['ESTABLISH_TRADE_ITEM'](state){
//         return {...state, loading: true};
//     },
//     ['ESTABLISH_TRADE_ITEM_SUCCESS'](state, action){
//         return {...state, loading: false, item: {...state.item, ...action.item}};
//     },
//     ['ESTABLISH_TRADE_ITEM_FAILED'](state, action){
//         return {...state, err: action.err, loading: false};
//     }
//
// }, initState);
//
// export default trade;


import {handleActions} from 'redux-actions';
import base, {init, loading, fail, update} from './base';

export default handleActions(base('TRADE', {
    SETTLEMENT_TRADE:loading,
    SETTLEMENT_TRADE_SUCCESS: update,
    SETTLEMENT_TRADE_FAILED: fail,
    ESTABLISH_TRADE: loading,
    ESTABLISH_TRADE_SUCCESS: function (state) {
        if(state.item){
            state.item.status = 21;
        }
        return {...state, loading: false};
    },
    ESTABLISH_TRADE_FAILED: fail
}), init());
