import {handleActions} from 'redux-actions';
import base, {init} from './base';

export default handleActions(base('AUTHORITY', {
    EDIT_AUTHORITY_SUCCESS: function (state, action) {
        try {
            if (action.data.permissions) {
                action.data.permissions = JSON.parse(action.data.permissions)
            }
        } catch (err) {
        }
        return {...state, loading: false, item: {...state.item, ...action.data},}
    },
    DELETE_AUTHORITY_SUCCESS: function (state, action) {
        state.items = state.items.filter(item=>item.name != action.data.id);
        return {...state, loading: false, removed: action.data.id}
    },
}), init());
