import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';
import FooterOperation from  '../../components/FooterOperation/FooterOperation';


import {
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    userStatusToString,
    formatDateTime,
    NULL,
    resourceActions,
    enableStatusToString,
    ENABLE_STATUS_LIST
} from '../../utils';


@connect(state=>({
    loading: state.resource.loading,
    item: state.resource.item,
    isEdit: state.resource.isEdit
}))
@Form.create()
export default class EditItem extends Component {
    constructor() {
        super(...arguments);
        this.state = {
            isEdit: false
        }
    }


    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_RESOURCE',
            data:{id}
        });
    };

    handleSubmit(e) {
        e.preventDefault();
        let data = {};
        data = this.props.form.getFieldsValue();
        data.id = this.props.params.id;
        if (isNaN(data.status)) {
            ENABLE_STATUS_LIST.forEach(item=> {
                if (item.text === data.status) {
                    data.status = item.value;
                    return false;
                }
            })
        }
        console.log(data);
        this.props.dispatch({
            type: 'EDIT_RESOURCE_SUBMIT',
            data
        });
    }

    render() {
        const {item, loading, form:{getFieldProps}, location:{query}, isEdit, dispatch} = this.props;

        const header = (
            <MainHeader breadcrumb={['权限管理', '权限资源详情']}
                        title={'权限资源详情' + (isEdit ? ' - 编辑' : '')}
                        operation={<HeaderOperation
                            buttons={item ? DetailOperations('RESOURCE', item.id, isEdit, dispatch) : []}/>}
            />
        );

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        item &&
                        <Form className="main-form" horizontal  onSubmit={this.handleSubmit.bind(this)}>

                            <Form.Item label="类别" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Select
                                            style={{width: 200}} {...getFieldProps('category', {initialValue: item.category})}>
                                            <Select.Option value="业务管理">业务管理</Select.Option>
                                            <Select.Option value="基础功能">基础功能</Select.Option>
                                            <Select.Option value="系统管理">系统管理</Select.Option>
                                        </Select>
                                        :
                                    item.category || NULL
                                }
                            </Form.Item>
                            <Form.Item label="名称" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input {...getFieldProps('description', {initialValue: item.description})} />
                                        :
                                    item.description || NULL
                                }
                            </Form.Item>
                            <Form.Item label="状态" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Select
                                            placeholder="请选择状态" {...getFieldProps('status', {initialValue: enableStatusToString(item.status)})} >
                                            <Select.Option value="1">系统</Select.Option>
                                            <Select.Option value="5">禁用</Select.Option>
                                            <Select.Option value="9">启用</Select.Option>
                                        </Select>
                                        :
                                        (typeof item.status !== 'undefined' ? enableStatusToString(item.status) : NULL)
                                }
                            </Form.Item>
                            <Form.Item label="controllerName" {...smallFormItemLayout}>
                                { item.controllerName }
                            </Form.Item>
                            <Form.Item label="Actions" {...smallFormItemLayout}>
                                {
                                    resourceActions(item.actionMask).map(({label, value})=>
                                        <span key={value} style={{marginRight: '1em'}}>{label}</span>
                                    )
                                }
                            </Form.Item>
                            <Form.Item label="创建时间" {...smallFormItemLayout}>
                                {item.dateCreated && formatDateTime(item.dateCreated)}
                            </Form.Item>
                            <FooterOperation {...this.props} isEdit={isEdit} command="RESOURCE"
                                             hasCancel={true}/>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}


