import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin,
    Breadcrumb
} from 'antd';
import * as ProductForm from '../../components/ProductForm/index';

import MainHeader from '../../components/MainHeader/MainHeader';

import Layout from '../../components/Layout/Layout';

/*class PublishForm extends Component {
    constructor(props, content) {
        super(props, content);
    }

    handlePublish(e) {
        e.preventDefault();
        const data = {
            id: this.props.product.id,
            status: 1
        };
        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });
    }


    render() {
        return (
            <div style={{textAlign:'center'}}>
                <h1>请确认产品各项信息已经填写完整!</h1>
                <Button type="primary" loading={this.props.loading} onClick={this.handlePublish.bind(this)}>
                    <Icon type="solution"/>发布
                </Button>
            </div>
        );
    }

}*/


@connect(state=>({
    user: state.user,
    cates: state.product.cates,
    product: state.product.item,
    loading: state.product.loading,
    isCreate: true,
    isEdit: true
}))
export default class AddItem extends Component {


    constructor(props, content) {
        super(props, content);
        this.state = {
            isEdit: true
        }
    }

    static propTypes = {
        dispatch: PropTypes.func,
        caste: PropTypes.array
    };


    componentDidMount() {
        const {cates} = this.props;
        if (!cates || !cates.length) {
            this.fetchCates();
        }

        this.props.dispatch({
            type: 'CREATE_PRODUCT_ITEM'
        });

    };

    componentWillReceiveProps(nextProps) {
        if (nextProps.product && nextProps.product.id) {
            this.props.dispatch({
                type: 'UPDATE_PRODUCT'
            });
        }
    }

    fetchCates() {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_CATES'
        });
    };


    render = ()=> {

        const {product, isEdit, isCreate} = this.props;


        const styles = require('./Product.less');

        const tabs = [
            {tab: '基本信息', children: ProductForm.BaseInfoForm},
            {tab: '收益佣金', children: ProductForm.ShouyiYongjingForm},
            {tab: '汇款账号', children: ProductForm.HuikuanInfoForm},
            {tab: '基本要素', children: ProductForm.ElementForm},
            {tab: '时间', children: ProductForm.DateTimeStatusForm},
            {tab: '相关附件', children: ProductForm.DocumentsForm},
            {tab: '服务经理', children: ProductForm.ContactForm},
            {tab: '发布', children: ProductForm.PublishForm}
        ].map((tabPane, index)=> {
            tabPane.key = 'tabs-pane-' + (index + 1);
            return tabPane;
        });

        const header = <MainHeader breadcrumb={['产品管理', '添加产品']} title="添加产品"/>;

        return (
            <Layout header={header}>
                <Tabs className={styles.tabs} tabPosition="left">
                    { tabs.map(tp=>
                        <Tabs.TabPane tab={tp.tab} key={tp.key}>
                            {product && <tp.children {...this.props} isEdit={isEdit} isCreate={true}/> }
                        </Tabs.TabPane>
                    )}
                </Tabs>
            </Layout>
        );
    }
}
