import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon, Button, Switch, Form} from 'antd';
import {serialize, formatDateTime, productStatusToString, footerFormSubmitLayout} from '../../utils';
import {Link} from 'react-router';
import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation from '../../components/HeaderOperation/HeaderOperation';


@connect(state=>({
    items: state.customMessage.items,
    loading: state.customMessage.loading,
    total: state.customMessage.total,
}))
export default class List extends Component {

    constructor(props, context) {
        super(props, context);
        this.state = {
            filterVisible: false
        }
    }

    componentDidMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(data) {
        this.props.dispatch({
            type: 'FETCH_MESSAGE_LIST',
            data
        });
    };

    handleRowClick({id}) {
        this.props.history.push('/customMessages/' + id);
    }


    render() {

        const {total, items, loading, history:{replace}, location:{pathname, query}} = this.props;

        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 30,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            showTotal: total => `共 ${total} 条`,
            pageSizeOptions: ['10', '30', '50', '100'],
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current)=> {
                console.log('Current: ', current);
                query.p = current;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };

        const columns = [
            {
                title: 'ID',
                dataIndex: 'id',
                key: 'id',
                width: 50
            }, {
                title: '推送时间',
                dataIndex: 'dateCreated',
                key: 'dateCreated',
                width: 150,
                className: 'tac',
                render: (dateCreated, record)=>(
                    <span>
                        {dateCreated && dateCreated.replace(/[年|月]/g, '-').replace(/日/g, '')}
                    </span>
                )
            }, {
                title: '推送渠道',
                dataIndex: 'channelName',
                key: 'channelName',
                className: 'tac',
                width: 120
            }, {
                title: '标题/内容',
                dataIndex: 'title',
                key: 'title',
                render: (title, record)=>(
                    <span>
                        {title || (record.contents && (record.contents + '').substr(0, 100)) || '无标题'}
                    </span>
                )
            }
        ];

        const buttons = [{
            key: 'add',
            link: '/customMessages/create',
            onClick: ()=> {
            }
        }, {
            key: 'filter',
        }];

        const operation = (
            <HeaderOperation history={this.props.history} buttons={buttons}/>
        );

        const header = (
            <MainHeader breadcrumb={['消息管理', '消息列表']} title="消息列表" operation={operation}/>
        );

        return (
            <Layout header={header}>
                <Table className="list-table" columns={columns}
                       dataSource={Array.isArray(items) ? items : []}
                       loading={loading}
                       pagination={pagination}
                       scroll={{y: window.innerHeight - (this.state.filterVisible ? 203 : 150)}}
                       onRowClick={this.handleRowClick.bind(this)}
                />
            </Layout>
        );
    }
}



