import {takeLatest} from 'redux-saga';
import {take, call, put, fork, cancel, select, race} from 'redux-saga/effects';
import { fetchList, fetchItem, updateItem, createItem, deleteItem } from '../services/admin/authority';
import {message} from 'antd';

import {watchIndex, watchShow, watchCreate, watchUpdate, watchEdit, watchDelete} from './RESTful';

export default function*() {
    const ID = 'AUTHORITY';
    yield fork(watchCreate(ID, createItem));
    yield fork(watchIndex(ID, fetchList));
    yield fork(watchShow(ID, fetchItem));
    yield fork(watchEdit(ID, updateItem));
    yield fork(watchDelete(ID, deleteItem));
}
