import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Link} from 'react-router';
import {Form, Input, Button, Checkbox, message, Row, Col, Spin, Icon} from 'antd';
import {
    formatDateTime,
    tradeStatusToString,
    tradeCreateTypeToString
} from '../../utils';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';

@connect(state=>({
    loading: state.customMessage.loading,
    item: state.customMessage.item
}))
export default class Item extends Component {

    componentDidMount() {
        const {dispatch, params:{id}} = this.props;
        dispatch({
            type: 'FETCH_MESSAGE_ITEM',
            id
        });
    };


    render() {
        const {item, loading, dispatch} = this.props;
        const styles = require('../Trade/Item.less');
        const tw = 8;
        const vw = 16;

        const operation = (
            <HeaderOperation history={this.props.history} buttons={[{key: 'rollback'}]}/>
        );

        const header = (
            <MainHeader breadcrumb={['消息管理', '消息详情']}
                        title={((item && item.title) ? item.title + ' - ' : '') + '消息详情'}
                        operation={operation}
            />
        );


        return (
            <Layout header={header}>
                {
                    item ?
                        <div className={styles.trade}>
                            <div className={styles.tradeTable}>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>消息ID</Col>
                                    <Col span={vw}>{item.id}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>推送渠道</Col>
                                    <Col
                                        span={vw}>{item.channelName}</Col>
                                </Row>
                                {
                                    item.channelType !== 1 &&
                                    <Row type="flex" justify="space-around" align="middle">
                                        <Col span={tw}>消息标题</Col>
                                        <Col span={vw}>{item.title}</Col>
                                    </Row>
                                }
                                {
                                    item.channelType !== 1 &&
                                    <Row type="flex" justify="space-around" align="middle">
                                        <Col span={tw}>消息摘要</Col>
                                        <Col span={vw}>
                                            <div style={{maxWidth: 600}}>{item.abstracts}</div>
                                        </Col>
                                    </Row>
                                }
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>消息正文</Col>
                                    <Col span={vw}>
                                        <div style={{maxWidth: 600}}>{item.contents}</div>
                                    </Col>
                                </Row>
                                {
                                    item.channelType !== 1 &&
                                    <Row type="flex" justify="space-around" align="middle">
                                        <Col span={tw}>跳转内容</Col>
                                        <Col span={vw}>
                                            <span>{'类型:' + (item.redirectName || '')}</span>
                                            {
                                                item.redirect &&
                                                <span style={{marginLeft: '1em'}}>{'内容:' + item.redirect}</span>
                                            }

                                        </Col>
                                    </Row>
                                }
                                {
                                    item.channelType !== 1 &&
                                    <Row type="flex" justify="space-around" align="middle">
                                        <Col span={tw}>推送人数</Col>
                                        <Col span={vw}>{item.count}</Col>
                                    </Row>
                                }
                                {
                                    item.channelType !== 1 &&
                                    <Row type="flex" justify="space-around" align="middle">
                                        <Col span={tw}>推送类型</Col>
                                        <Col span={vw}>{item.sendName}</Col>
                                    </Row>
                                }
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>推送时间</Col>
                                    <Col
                                        span={vw}>{item.dateCreated && (item.dateCreated + '').replace(/[年月]/g, '-').replace(/日/g, '')}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>推送对象</Col>
                                    <Col span={vw}>
                                        <div style={{maxWidth: 600}}>{item.send}</div>
                                    </Col>
                                </Row>
                            </div>
                            <p>
                                <Button onClick={e=> {
                                    e.preventDefault();
                                    this.props.history.goBack();
                                }}
                                        style={{marginLeft: '1em'}}>
                                    <Icon type="rollback"/>返回
                                </Button>
                            </p>
                        </div>
                        :
                        <Spin spinning={loading}/>
                }
            </Layout>
        );

    }
};
