import xFetch from './xFetch';
import {serialize} from '../utils';

export async function fetch(username, password) {
    return xFetch('/api/authenticate', {
        method: 'POST',
        body: serialize({username, password})
    });
}

export async function create(data) {
    return xFetch('/api/users', {
        method: 'POST',
        body: serialize(data)
    });
}
export async function modifyPassword(data) {
    return xFetch('/api/users/' + data.username, {
        method: 'PATCH',
        body: serialize(data)
    });
}


export async function fetchList(query) {
    return xFetch('/api/admin/users' + '?' + serialize({s: 30, ...query}));
}

export async function fetchItem(id) {
    let url = /^\/admin\//.test(location.pathname) ? '/api/admin/users/' + id : '/api/users/' + id;
    return xFetch(url);
}

export async function updateItem(data) {
    let url;
    if(/^\/admin\//.test(location.pathname)){
        url = '/api/admin/users/' + data.id;
    }else{
        url = '/api/users/' + data.id;
    }
    return xFetch(url, {
        method: 'PUT',
        body: serialize(data)
    })
}





