import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const product = handleActions({
    ['FETCH_PRODUCT_LIST'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_PRODUCT_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, items: action.items, total: action.total};
    },
    ['FETCH_PRODUCT_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false,};
    },
    ['FETCH_PRODUCT_CATES'](state){
        return {...state, loading: true};
    },
    ['FETCH_PRODUCT_CATES_SUCCESS'](state, action){
        return {...state, loading: false, cates: action.cates};
    },
    ['FETCH_PRODUCT_CATES_FAILED'](state, action){
        return {...state, err: action.err, loading: false};
    },
    ['FETCH_PRODUCT_ITEM'](state){
        return {...state, loading: true}
    },
    ['FETCH_PRODUCT_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: action.item}
    },
    ['FETCH_PRODUCT_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false}
    },


    ['UPDATE_PRODUCT_START'](state){
        return {...state, isEdit: true}
    },
    ['UPDATE_PRODUCT_END'](state){
        return {...state, isEdit: false}
    },
    ['UPDATE_PRODUCT_ITEM'](state){
        return {...state, loading: true};
    },
    ['UPDATE_PRODUCT_ITEM_SUCCESS'](state, action){
        if(action.item && action.item.commissionAlg && typeof action.item.commissionAlg === 'string'){
            try{
                action.item.commissionAlg = JSON.parse(action.item.commissionAlg);
            }catch(err){
                console.log('UPDATE_PRODUCT_ITEM_SUCCESS commissionAlg Error:', action.item.commissionAlg);
            }
        }
        if(action.item && action.item.elements && typeof action.item.elements === 'string'){
            try {
                action.item.elements = JSON.parse(action.item.elements);
            }catch(err){
                console.log('UPDATE_PRODUCT_ITEM_SUCCESS elements Error:', action.item.elements);
            }
        }
        if(action.item && action.item.staffs && typeof action.item.staffs === 'string'){
            try{
                action.item.staffs = JSON.parse(action.item.staffs);
            }catch(err){
                console.log('UPDATE_PRODUCT_ITEM_SUCCESS staffs Error:', action.item.staffs);
            }
        }
        const ret = {...state, loading: false, item:{...state.item, ...action.item}};

        console.log(ret, state);
        return ret;
    },
    ['UPDATE_PRODUCT_ITEM_FAILED'](state, action){
        return {...state, loading: false, err: action.err};
    },


    ['CREATE_PRODUCT_ITEM'](state){
        return {...state, loading: true};
    },
    ['CREATE_PRODUCT_ITEM_SUCCESS'](state, action){
        return {...state, item: action.item, loading: false};
    },
    ['CREATE_PRODUCT_FAILED'](state, action){
        return {...state, loading: false, err: action.err};
    }
}, {
    //cates: [],
    items: [],
    loading: false,
});

export default product;
