import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Form, Input, Button, Checkbox, message, Spin} from 'antd';

@connect(state=>({
    loading: state.user.loading
}))
@Form.create()
export default class Login extends Component {

    static propTypes = {
        form: PropTypes.object,
        dispatch: PropTypes.func,

    };

    handleSubmit = (e)=> {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        console.log('收到表单值：', data);
        this.props.dispatch({
            ...data,
            push: this.props.history.push,
            type: 'LOGIN_REQUEST'
        });
    };

    render = ()=> {
        const {form:{getFieldProps}, loading} = this.props;
        const styles = require('./Login.less');
        const bg = require('./images/bg1.jpg');
        return (
            <Spin spinning={loading} tip="正在登录...">

                <div className={styles.normal}>
                    <div className={styles.content}>
                        <div className={styles['login-bg']}>
                            <img src={bg}/>
                        </div>
                        <div className={styles['login-container']}>
                            <div>
                                <div>
                                    <h1>枢纽科技后台管理系统</h1>
                                    <Form inline onSubmit={this.handleSubmit.bind(this)}>
                                        <div>
                                            <Form.Item>
                                                <Input placeholder="请输入账户名" {...getFieldProps('username')} />
                                            </Form.Item>
                                            <Form.Item>
                                                <Input type="password"
                                                       placeholder="请输入密码" {...getFieldProps('password')} />
                                            </Form.Item>
                                        </div>
                                        <div>
                                            <Form.Item>
                                                <Checkbox {...getFieldProps('agreement')}>记住我</Checkbox>
                                            </Form.Item>
                                            <Button type="primary" htmlType="submit">登录</Button>
                                        </div>
                                    </Form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </Spin>
        );
    }
}

