import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

import {formItemLayout, footerFormSubmitLayout} from '../../utils';

@connect(state=>({
    loading: state.announcement.loading,
    item: state.announcement.item
}))
@Form.create()
export default class AddItem extends Component {
    constructor(props, content) {
        super(props, content);
    }

    componentDidMount(){
        const {item} = this.props;
        if (item && item.id) {
            this.props.dispatch({
                type: 'INIT_ANNOUNCEMENT'
            });
        }
    }

    componentWillReceiveProps(nextProps) {
        const {item} = nextProps;
        if (item && item.id) {
            this.props.history.push('/announcement/' + item.id);
            this.props.dispatch({
                type: 'INIT_ANNOUNCEMENT'
            });
        }
    }

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.itemId = this.props.location.query.itemId;
        console.log(data);
        this.props.dispatch({
            type: 'CREATE_ANNOUNCEMENT_ITEM',
            data
        });
    }

    render = ()=> {
        const {loading, form:{getFieldProps}, location:{query}} = this.props;

        const operation = (
            <div style={{textAlign:'right'}}>
                <Button.Group>
                    <Button type="ghost" onClick={e=>{e.preventDefault(); this.props.history.goBack();}}>
                        <Icon type="rollback"/>
                    </Button>
                </Button.Group>
            </div>
        );

        const header = (
            <MainHeader breadcrumb={['产品管理', '产品详情', '添加公告']}
                        title={(query.title ? query.title + ' - ' : '') + '添加公告'}
                        operation={operation}
            />
        );
        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    <Form className="main-form" horizontal onSubmit={this.handleSubmit.bind(this)}>
                        <Form.Item label="标题" {...formItemLayout}>
                            <Input placeholder="公告标题" {...getFieldProps('title')}  />
                        </Form.Item>
                        <Form.Item label="内容" {...formItemLayout}>
                            <Input placeholder="公告内容" type="textarea"
                                   autosize={{minRows:5, maxRows:20}} {...getFieldProps('announcement')}  />
                        </Form.Item>
                        <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                            <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>创建</Button>
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback"/>返回
                            </Button>
                        </Form.Item>
                    </Form>
                </Spin>
            </Layout>
        );
    }
}
