import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {
    arrayRemoveIndex,
    UUID,
    NULL,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout
} from '../../utils';


@Form.create()
export default class ContactForm extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            staffs: props.product.staffs.map(staffs=> {
                staffs.key = UUID();
                return staffs;
            })
        };

    }

    componentWillReceiveProps(nextProps) {
        if (nextProps && nextProps.product.staffs && nextProps.product.staffs) {
            if (nextProps.product.staffs.length != this.props.product.staffs.length) {
                this.setState({
                    staffs: nextProps.product.staffs.map(staffs=> {
                        staffs.key = UUID();
                        return staffs;
                    })
                });
            } else {

            }
        }
    }

    static propsType = {
        product: PropTypes.object,
    };

    /**
     * 删除基本要素
     * @param index
     * @param e
     */
    handleRemove(index, e) {
        e.preventDefault();
        const staffs = arrayRemoveIndex(this.state.staffs, index);
        this.setState({staffs: staffs});
    }

    /**
     * 添加基本要素
     * @param e
     */
    handleAdd(e) {
        e.preventDefault();
        let staffs = [].concat(this.state.staffs);
        staffs.push({key: UUID()});

        this.setState({staffs});
    }

    handleSubmit(e) {
        e.preventDefault();
        const formData = this.props.form.getFieldsValue();
        const tmp = Object.keys(formData).map(index=> {
            return {
                ...formData[index]
            }
        }).filter(item=>item.name && item.mobile);
        const data = {
            id: this.props.product.id,
            staffs: JSON.stringify(tmp)
        }

        console.log('收到表单值：', data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });


    }

    render() {
        const {form:{getFieldProps}, loading, isEdit}  = this.props;
        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                    <Row style={{padding:'0 20px'}}>
                        <Col span="24">
                            {
                                isEdit ?
                                    <Form.Item>
                                        {
                                            this.state.staffs.map((item, index)=>
                                                <div key={item.key} style={{marginBottom:8}}>
                                                    <Input.Group>
                                                        <Col span="6">
                                                            <Input placeholder="姓名"
                                                                {...getFieldProps(item.key + '.name', {
                                                                    initialValue: item.name
                                                                })} />
                                                        </Col>
                                                        <Col span="10">
                                                            <Input placeholder="电话"
                                                                {...getFieldProps(item.key + '.mobile', {
                                                                    initialValue: item.mobile
                                                                })}/>
                                                        </Col>
                                                        <Col span="4">
                                                            <Icon type="cross" title="删除"
                                                                  onClick={this.handleRemove.bind(this, index)}/>
                                                        </Col>
                                                    </Input.Group>
                                                </div>
                                            )
                                        }
                                    </Form.Item>
                                    :

                                    this.state.staffs.length ?
                                        <table>
                                            <thead>
                                            <tr>
                                                <th>姓名</th>
                                                <th>电话</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            {
                                                this.state.staffs.map((item, index)=>
                                                    <tr key={index}>
                                                        <td>{item.name}</td>
                                                        <td>{item.mobile || NULL}</td>
                                                    </tr>
                                                )
                                            }
                                            </tbody>
                                        </table>
                                        :
                                        <Form.Item {...footerFormSubmitLayout}>
                                            还没有设置过任何一位服务经理及其联系电话
                                        </Form.Item>

                            }

                            <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                {
                                    isEdit ?
                                        <span>
                                            <Button size="large" onClick={this.handleAdd.bind(this)}
                                                    style={{marginRight:'1em'}}>
                                                <Icon type="plus"/>添加
                                            </Button>
                                            <Button size="large" type="primary" htmlType="submit" loading={loading}>
                                                <Icon type="save"/>保存
                                            </Button>
                                        </span>
                                        :
                                        <Button type="primary" onClick={e=>{
                                            e.preventDefault();
                                            this.props.dispatch({
                                                type:'UPDATE_PRODUCT'
                                            });
                                        }}>
                                            <Icon type="edit"/>编辑
                                        </Button>
                                }
                                {
                                    !this.props.isCreate &&
                                    <Button onClick={e=>{
                                            e.preventDefault();
                                            isEdit ?
                                                this.props.dispatch({
                                                    type: 'CANCEL_UPDATE_PRODUCT'
                                                }) :
                                                this.props.history.goBack();
                                        }}
                                            style={{marginLeft:'1em'}}>
                                        <Icon type="rollback"/>
                                        {isEdit ? '取消' : '返回'}
                                    </Button>
                                }
                            </Form.Item>
                        </Col>
                    </Row>
                </Form>
            </Spin>
        );
    }
}
