import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const withdraw = handleActions({
    ['FETCH_WITHDRAW_LIST'](state) {
        return {...state, loading: true};
    },
    ['FETCH_WITHDRAW_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, audits: action.items, total: action.total};
    },
    ['FETCH_WITHDRAW_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false};
    },
    ['FETCH_WITHDRAW_ITEM'](state) {
        return {...state, loading: true};
    },
    ['FETCH_WITHDRAW_ITEM_SUCCESS'](state, action) {
        return {...state, loading: false, audit: action.item};
    },
    ['FETCH_WITHDRAW_ITEM_FAILED'](state, action) {
        return {...state, err: action.err, loading: false};
    },
    ['PASS_WITHDRAW_ITEM'](state){
        return {...state, loading: true};
    },
    ['PASS_WITHDRAW_ITEM_SUCCESS'](state, action){
        const audit = {...state.audit, status: action.status};
        if(action.status == 5){
            audit.memo = action.memo;
        }
        return {...state, loading: false, audit};
    },
    ['PASS_WITHDRAW_ITEM_FAILED'](state, action){
        return {...state, loading: false, err: action.err};
    }
}, {
    audits: [],
    loading: false,
});


export default withdraw;
