import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

import {formItemLayout, footerFormSubmitLayout} from '../../utils';

@connect(state=>({
    loading: state.customMessage.loading,
}))
@Form.create()
export default class AddItem extends Component {
    constructor(props, content) {
        super(props, content);
        this.state = {
            redirectName: undefined,
            sendName: undefined
        }
    }

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.customMessage.redirectType = this.state.redirectName;
        data.customMessage.sendType = this.state.sendName;


        console.log(data);
        this.props.dispatch({
            type: 'CREATE_MESSAGE_ITEM',
            data
        });
    }

    render = ()=> {
        const {loading, form:{getFieldProps}, location:{query}} = this.props;

        const header = (
            <MainHeader breadcrumb={['消息管理', '推送消息']} title="推送消息"/>
        );

        const redirectNamePlaceholder = {0: '无需填写', 1: '请输入一个产品ID', 2: '请输入消息跳转指定的URL地址'};

        const sendNamePlaceholder = {1: '无需填写', 2: '请输入一个产品ID', 3: '请输入接收消息的人员的手机号码'};


        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    <Form className="main-form" horizontal onSubmit={this.handleSubmit.bind(this)}>
                        <Form.Item label="推送渠道" {...formItemLayout}>
                            <Row>
                                <Col span="6">
                                    <Select placeholder="请选择" {...getFieldProps('customMessage.channelType')} >
                                        <Select.Option value="1">微信</Select.Option>
                                        <Select.Option value="3">APP</Select.Option>
                                    </Select>
                                </Col>
                            </Row>
                        </Form.Item>
                        <Form.Item label="消息跳转" {...formItemLayout}>
                            <Row>
                                <Col span="6">
                                    <Select placeholder="请选择"
                                            value={this.state.redirectName}
                                            onChange={value=>this.setState({redirectName: value})}>
                                        <Select.Option value="0">无</Select.Option>
                                        <Select.Option value="1">产品ID</Select.Option>
                                        <Select.Option value="2">URL</Select.Option>
                                    </Select>
                                </Col>
                                <Col span="18" style={{paddingLeft:'.5em'}}>
                                    <Input placeholder={redirectNamePlaceholder[this.state.redirectName]}
                                        {...getFieldProps('customMessage.redirect')} />
                                </Col>
                            </Row>
                        </Form.Item>
                        <Form.Item label="推送对象" {...formItemLayout}>
                            <Row>
                                <Col span="6">
                                    <Select placeholder="请选择"
                                            value={this.state.sendName}
                                            onChange={value=>this.setState({sendName: value})}>
                                        <Select.Option value="1">全局推送</Select.Option>
                                        <Select.Option value="2">产品ID</Select.Option>
                                        <Select.Option value="3">手动导入</Select.Option>
                                    </Select>
                                </Col>
                                <Col span="18" style={{paddingLeft:'.5em'}}>
                                    <Input placeholder={sendNamePlaceholder[this.state.sendName]}
                                        {...getFieldProps('customMessage.send')} />
                                </Col>
                            </Row>
                        </Form.Item>
                        <Form.Item label="消息标题" {...formItemLayout}>
                            <Input placeholder="消息标题" {...getFieldProps('customMessage.title')}  />
                        </Form.Item>
                        <Form.Item label="消息摘要" {...formItemLayout}>
                            <Input placeholder="消息摘要" type="textarea"
                                   autosize={{minRows:3, maxRows:10}} {...getFieldProps('customMessage.abstracts')}  />
                        </Form.Item>
                        <Form.Item label="消息正文" {...formItemLayout}>
                            <Input placeholder="消息正文" type="textarea"
                                   autosize={{minRows:3, maxRows:10}} {...getFieldProps('customMessage.contents')}  />
                        </Form.Item>
                        <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                            <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>立即推送</Button>
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback"/>返回
                            </Button>
                        </Form.Item>
                    </Form>
                </Spin>
            </Layout>
        );
    }
}
