import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Breadcrumb,
    Icon
} from 'antd';


export default class MainHeader extends Component {
    static propType = {
        breadcrumb: PropTypes.array,
        title: PropTypes.node
    };

    render() {

        const {breadcrumb, title, operation} = this.props;

        const styles = require('./MainHeader.less');

        return (
            <div className={styles.MainHeader}>
                <Row className={styles.header} type="flex" justify="space-around" align="middle">
                    <Col span="16" style={{paddingLeft: 20}}>
                        <h1>{title}</h1>
                        <Icon type="heart"/>
                        <Breadcrumb>
                            { breadcrumb.map((b, i)=><Breadcrumb.Item key={i}>{b}</Breadcrumb.Item>) }
                        </Breadcrumb>
                    </Col>
                    <Col span="8">
                        {operation}
                    </Col>
                </Row>
                { this.props.children }
            </div>

        );
    }
}
