import React, {PropTypes, Component} from 'react';
import {Route, IndexRoute, Link} from 'react-router';
import * as Containers from '../containers/index';

export default (store)=> {
    const requireAuth = (nextState, replace, cb) => {
        const {user} = store.getState();
        if (!user || !user.token) {
            replace('/login');
        }
        cb();
    };
    return (
        <Route path="/">
            <Route onEnter={requireAuth} component={Containers.App}>
                <IndexRoute component={Containers.Home}/>
                <Route path="products">
                    <IndexRoute component={Containers.ProductList}/>
                    <Route path="create" component={Containers.ProductAddItem}/>
                    <Route path=":id" component={Containers.ProductEditItem}/>
                </Route>
                <Route path="trades">
                    <IndexRoute component={Containers.TradeList}/>
                    <Route path="create" component={Containers.TradeAddItem}/>
                    <Route path=":id" component={Containers.TradeItem}/>
                    <Route path="commission/:id" component={Containers.Commission}/>
                    <Route path="contract/:id" component={Containers.Contract}/>
                </Route>
                <Route path="announcement">
                    <IndexRoute component={Containers.AnnouncementList}/>
                    <Route path="create" component={Containers.AnnouncementEditItem}/>
                    <Route path=":id" component={Containers.AnnouncementEditItem}/>
                </Route>
                <Route path="remittance">
                    <Route path="audits">
                        <IndexRoute component={Containers.RemittanceAuditList}/>
                        <Route path=":id" component={Containers.RemittanceAuditPassItem}/>
                    </Route>
                </Route>
                <Route path="withdraw">
                    <Route path="audits">
                        <IndexRoute component={Containers.WithDrawList}/>
                        <Route path=":id" component={Containers.PassWithDrawItem}/>
                    </Route>
                </Route>
                <Route path="authInfo">
                    <Route path="audits">
                        <IndexRoute component={Containers.AuthInfoList}/>
                        <Route path=":id" component={Containers.AuthInfoItem}/>
                    </Route>
                </Route>
                <Route path="customMessages">
                    <IndexRoute component={Containers.CustomMessageList}/>
                    <Route path="create" component={Containers.CustomMessageAddItem}/>
                    <Route path=":id" component={Containers.CustomMessageItem}/>
                </Route>
                <Route path="upload" component={Containers.BaseUpload}/>
                <Route path="admin">
                    <Route path="users">
                        <IndexRoute component={Containers.UsersList}/>
                        <Route path=":id" component={Containers.UsersItem}/>
                    </Route>
                    <Route path="resources">
                        <IndexRoute component={Containers.ResourceList}/>
                        <Route path=":id" component={Containers.ResourceItem}/>
                    </Route>
                    <Route path="authorities">
                        <IndexRoute component={Containers.AuthorityList}/>
                        <Route path="create" component={Containers.AuthorityItem}/>
                        <Route path=":id" component={Containers.AuthorityItem}/>
                    </Route>
                </Route>
                <Route path="my">
                    <Route path="modifyPassword" component={Containers.ModifyPassword}/>
                </Route>
            </Route>
            <Route path="/login" component={Containers.Login}/>
            <Route path="/register" component={Containers.Register}/>
            <Route path="*" component={Containers.NotFound}/>
        </Route>
    );
};

//
