import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const message = handleActions({
    ['FETCH_MESSAGE_LIST'](state) {
        return {...state, loading: true};
    },
    ['FETCH_MESSAGE_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, items: action.items, total: action.total};
    },
    ['FETCH_MESSAGE_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false, items: [], total: 0};
    },
    ['FETCH_MESSAGE_ITEM'](state){
        return {...state, loading: true}
    },
    ['FETCH_MESSAGE_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: action.item}
    },
    ['FETCH_MESSAGE_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false, item: null}
    },
    ['CREATE_MESSAGE_ITEM'](state){
        return {...state, loading: true}
    },
    ['CREATE_MESSAGE_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: action.item}
    },
    ['CREATE_MESSAGE_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false, item: null}
    }
}, {
    items: [],
    loading: false,
});

export default message;
