import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const authInfo = handleActions({
    ['FETCH_AUTHINFO_LIST'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_AUTHINFO_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, audits: action.items, total: action.total};
    },
    ['FETCH_AUTHINFO_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false, audits: [], total: 0};
    },
    ['FETCH_AUTHINFO_ITEM'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_AUTHINFO_ITEM_SUCCESS'](state, action) {
        return {...state, loading: false, audit: action.item};
    },
    ['FETCH_AUTHINFO_ITEM_FAILED'](state, action) {
        return {...state, err: action.err, loading: false, audit: null};
    },
    ['PASS_AUTHINFO_ITEM'](state){
        return {...state, loading: true};
    },
    ['PASS_AUTHINFO_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, audit: {...state.audit, ...action.data}};
    },
    ['PASS_AUTHINFO_ITEM_FAILED'](state, action){
        return {...state, loading: false, err: action.err};
    }
}, {
    audits: [],
    loading: false,
});


export default authInfo;
