import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Form, Input, Button, Checkbox, message, Spin} from 'antd';
import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

import {formItemLayout, footerFormSubmitLayout} from '../../utils';

@connect(state=>({
    loading: state.user.loading,
    created: state.user.created
}))
@Form.create()
export default class Register extends Component {

    componentWillReceiveProps(nextProps) {
        if (nextProps.created) {
            // this.props.history.replace('/login');
        }
    }

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        console.log(data);
        this.props.dispatch({
            type: 'CREATE_USER',
            data
        });
    }

    render() {
        const {form:{getFieldProps}, loading} = this.props;
        return (
            <Layout>
                <Spin spinning={loading}>
                    <Form className="main-form" horizontal onSubmit={this.handleSubmit.bind(this)}>
                        <div style={{width: 400, margin: 'auto', paddingTop: 200}}>
                            <Form.Item label="用户名" {...formItemLayout}>
                                <Input placeholder="请输入账户名" {...getFieldProps('username')} />
                            </Form.Item>
                            <Form.Item label="密码" {...formItemLayout}>
                                <Input type="password" placeholder="请输入密码" {...getFieldProps('password')} />
                            </Form.Item>
                            <Form.Item label="重复密码" {...formItemLayout}>
                                <Input type="password" placeholder="请再次输入密码" {...getFieldProps('confirmPassword')} />
                            </Form.Item>
                            <Form.Item label="昵称" {...formItemLayout}>
                                <Input placeholder="请输入昵称" {...getFieldProps('nick')} />
                            </Form.Item>
                            <Form.Item label="E-mail" {...formItemLayout}>
                                <Input placeholder="请输入E-mail" {...getFieldProps('email')} />
                            </Form.Item>
                            <Form.Item label="手机号" {...formItemLayout}>
                                <Input placeholder="请输入手机号" {...getFieldProps('mobile')} />
                            </Form.Item>
                            <Form.Item {...footerFormSubmitLayout}>
                                <Button type="primary" htmlType="submit">注册</Button>
                            </Form.Item>
                        </div>
                    </Form>
                </Spin>
            </Layout>
        );
    }
}
