import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Link} from 'react-router';
import {Form, Input, Button, Popconfirm, Checkbox, message, Row, Col, Spin, Icon} from 'antd';
import {
    formatDateTime,
    tradeStatusToString,
    tradeCreateTypeToString
} from '../../utils';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';


@connect(state=>({
    loading: state.trade.loading,
    item: state.trade.item
}))
export default class Item extends Component {

    componentDidMount() {
        const {dispatch, params:{id}} = this.props;
        dispatch({
            type: 'FETCH_TRADE_ITEM',
            id
        });
    };

    handleEstablish(id) {
        this.props.dispatch({
            type: 'ESTABLISH_TRADE_ITEM',
            id
        });
    }


    render() {
        const {item, loading} = this.props;
        const styles = require('./Item.less');
        const tw = 8;
        const vw = 16;


        const operation = (
            <HeaderOperation history={this.props.history} buttons={[{key:'rollback'}]}/>
        );

        const header = (<MainHeader breadcrumb={['订单管理', '订单详情']}
                                    operation={operation}
                                    title={((item && item.title) ? item.title + ' - ' : '') + '订单详情'}/>);

        return (
            <Layout header={header}>
                {
                    item ?
                        <div className={styles.trade}>
                            <div className={styles.tradeTable}>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>产品</Col>
                                    <Col span={vw}>{item.title}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>募集开始时间</Col>
                                    <Col
                                        span={vw}>{item.fundRaisedStartTime && formatDateTime(item.fundRaisedStartTime)}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>募集结束时间</Col>
                                    <Col
                                        span={vw}>{item.fundRaisedEndTime && formatDateTime(item.fundRaisedEndTime)}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>状态</Col>
                                    <Col span={vw}>{tradeStatusToString(item.status)}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>创建类型</Col>
                                    <Col span={vw}>{tradeCreateTypeToString(item.type)}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>预约时间</Col>
                                    <Col span={vw}>{formatDateTime(item.reservationTime)}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>预约金额</Col>
                                    <Col span={vw}>{item.reservationAmount}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>预期回报</Col>
                                    <Col span={vw}>
                                        {
                                            item.prospectiveReturn && item.prospectiveReturn.sy &&
                                            <span>{'收益 ' + item.prospectiveReturn.sy}</span>
                                        }
                                        {
                                            item.prospectiveReturn && item.prospectiveReturn.yj &&
                                            <span>{'佣金 ' + item.prospectiveReturn.yj}</span>
                                        }
                                    </Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>报单时间</Col>
                                    <Col
                                        span={vw}>{item.submitReceiptTime && formatDateTime(item.submitReceiptTime)}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>打款审核时间</Col>
                                    <Col
                                        span={vw}>{item.remittanceAuditTime && formatDateTime(item.remittanceAuditTime)}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>确认打款金额</Col>
                                    <Col span={vw}>{item.remittanceAmount}</Col>
                                </Row>

                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>实际回报</Col>
                                    <Col span={vw}>
                                        {
                                            item.realReturn && item.realReturn.sy &&
                                            <span>{'收益 ' + item.realReturn.sy}</span>
                                        }
                                        {
                                            item.commission &&
                                            <span>{'佣金 ' + item.commission + '元'}</span>
                                        }
                                    </Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>买家名字</Col>
                                    <Col span={vw}>{item.buyerName}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>买家身份证</Col>
                                    <Col span={vw}>{item.buyerIdentityCardNumber}</Col>
                                </Row>
                                <Row type="flex" justify="space-around" align="middle">
                                    <Col span={tw}>创建时间</Col>
                                    <Col span={vw}>{item.dateCreated && formatDateTime(item.dateCreated)}</Col>
                                </Row>
                            </div>
                            <p>
                                {
                                    item.status == 11 &&
                                    <Popconfirm title="确定这个订单要成立了吗？" onConfirm={this.handleEstablish.bind(this, item.id)}>
                                        <Button type="primary"
                                                style={{marginRignt:'1em'}}>
                                            <Icon type="like"/>订单成立
                                        </Button>
                                    </Popconfirm>
                                }
                                {
                                    (item.status == 11 || item.status == 21) && (!item.commissionId) &&
                                    <Link to={'/trades/commission/'+ item.id}>
                                        <Button type="ghost">
                                            <Icon type="pay-circle-o"/>发放佣金
                                        </Button>
                                    </Link>
                                }
                                <Link to={'/trades/contract/'+ item.id}>
                                    <Button type="ghost">
                                        <Icon type="exception"/>邮寄合同
                                    </Button>
                                </Link>
                                <Button type="ghost" onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                        style={{marginLeft:'1em'}}>
                                    <Icon type="rollback"/>返回
                                </Button>
                            </p>
                        </div>
                        :
                        <Spin spinning={loading}/>
                }
            </Layout>
        );

    }
};
