import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

let _user = sessionStorage.getItem('user');
try{
    _user = JSON.parse(_user);
}catch(ex){
    _user = {};
}

const user = handleActions({
    ['LOGIN_REQUEST'](state) {
        return {...state, loading: true};
    },
    ['LOGIN_SUCCESS'](state, action) {
        sessionStorage.setItem('user', JSON.stringify(action.user));
        return {...state, loading: false, ...action.user};
    },
    ['LOGIN_ERROR'](state, action) {
        return {...state, err: action.err, loading: false};
    },
    ['LOGOUT'](state) {
        return {...state, auth: {}, loading: false};
    }
}, {
    ..._user,
    loading: false
});

export default user;
