import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader';

import {
    formatDateTime,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    remittanceAuditStatusToString
} from '../../utils';

@connect(state=>({
    loading: state.remittance.loading,
    audit: state.remittance.audit,
}))
@Form.create()
export default class PassItem extends Component {
    constructor() {
        super(...arguments);
    }


    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_REMITTANCE_ITEM',
            id
        });
    };

    handleSubmit(status, e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.id = this.props.params.id;
        data.status = status;
        console.log(data);
        if (status == 9) {
            delete data.memo;
        }
        this.props.dispatch({
            type: 'PASS_REMITTANCE_ITEM',
            data
        });
    }

    render() {
        const {audit, loading, form:{getFieldProps}, location:{query}} = this.props;

        let title = (audit && audit.itemShortTitle ? audit.itemShortTitle + ' - ' : '');

        let readOnly = true;

        if (audit) {
            switch (audit.status) {
                case 1:
                    title += '报单审核详情';
                    readOnly = false;
                    break;
                case 5:
                    title += '审核失败';
                    break;
                case 9:
                    title += '审核成功';
            }
        } else {
            title += '报单审核详情';
        }

        const header = (<MainHeader breadcrumb={['审核管理', '报单审核','审核详情']} title={title}/>);

        const imgStyle = {maxWidth: '400px'};


        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        audit &&
                        <Form horizontal>
                            <Form.Item label="报单时间" {...smallFormItemLayout}>
                                <Input placeholder="报单时间" readOnly
                                       defaultValue={audit.dateCreated && formatDateTime(audit.dateCreated) || '错误的时间'}
                                />
                            </Form.Item>
                            <Form.Item label="产品募集情况" {...smallFormItemLayout}>
                                <Input placeholder="产品募集情况" readOnly
                                       defaultValue={'已募集:'+audit.fundRaisedOver+'、募集目标:'+audit.fundRaisedTarget}
                                />
                            </Form.Item>
                            <Form.Item label="预约金额" {...smallFormItemLayout}>
                                <Input placeholder="预约金额" readOnly defaultValue={audit.reservationAmount}/>
                            </Form.Item>
                            <Form.Item label="实际入账金额" help="实际入账金额，请核对打款凭条" {...smallFormItemLayout}>
                                <Input placeholder="实际入账金额" readOnly={readOnly}
                                    {...getFieldProps('remittanceAmount', {
                                        initialValue: audit.remittanceAmount
                                    })}  />
                            </Form.Item>
                            <Form.Item label="预约姓名" {...smallFormItemLayout}>
                                <Input placeholder="预约姓名" readOnly defaultValue={audit.buyerName}/>
                            </Form.Item>
                            <Form.Item label="投资人姓名" help="真实的投资人姓名，请核对身份证照片上的姓名" {...smallFormItemLayout}>
                                <Input placeholder="投资人姓名" readOnly={readOnly}
                                    {...getFieldProps('realName', {
                                        initialValue: audit.realName
                                    })}  />
                            </Form.Item>
                            <Form.Item label="投资人身份证号码" help="真实的投资人身份证号码，请核对身份证照片上的号码" {...smallFormItemLayout}>
                                <Input placeholder="投资人身份证号码" readOnly={readOnly}
                                    {...getFieldProps('identityCardNumber', {
                                        initialValue: audit.identityCardNumber
                                    })}  />
                            </Form.Item>
                            <Form.Item label="投资人身份证照片" {...smallFormItemLayout}>
                                {
                                    audit.identityCardFront && audit.identityCardBack ?
                                        <p>
                                            <a href={audit.identityCardFront} target="_blank">
                                                <img src={audit.identityCardFront} style={imgStyle}/>
                                            </a>
                                            <a href={audit.identityCardBack} target="_blank">
                                                <img src={audit.identityCardBack} style={imgStyle}/>
                                            </a>
                                        </p>
                                        :
                                        <p style={{color:'#f00'}}>
                                            <Icon type="cross-circle-o" style={{ marginRight:'.5em'}}/>
                                            身份证照片未上传，请拒绝!
                                        </p>
                                }
                            </Form.Item>
                            <Form.Item label="投资人银行卡照片" {...smallFormItemLayout}>
                                {
                                    audit.bankCardPic ?
                                        <a href={audit.bankCardPic} target="_blank">
                                            <img src={audit.bankCardPic} style={imgStyle}/>
                                        </a>
                                        :
                                        <p style={{color:'#f00'}}>
                                            <Icon type="cross-circle-o" style={{ marginRight:'.5em'}}/>
                                            银行卡照片未上传，请拒绝!
                                        </p>
                                }
                            </Form.Item>
                            <Form.Item label="投资人打款凭条" {...smallFormItemLayout}>
                                {
                                    audit.remittanceReceipt ?
                                        <a href={audit.remittanceReceipt} target="_blank">
                                            <img src={audit.remittanceReceipt} style={imgStyle}/>
                                        </a>
                                        :
                                        <p style={{color:'#f00'}}>
                                            <Icon type="cross-circle-o" style={{ marginRight:'.5em'}}/>
                                            打款凭条照片未上传，请拒绝!
                                        </p>
                                }

                            </Form.Item>
                            <Form.Item label="投资人签字页" {...smallFormItemLayout}>
                                {
                                    audit.signaturePages.length ?
                                        audit.signaturePages.map((img, index)=>
                                            <a href={img} target="_blank">
                                                <img key={index} src={img} style={imgStyle}/>
                                            </a>
                                        )
                                        :
                                        <p style={{color:'#f00'}}>
                                            <Icon type="cross-circle-o" style={{ marginRight:'.5em'}}/>
                                            签字页照片未上传，请拒绝!
                                        </p>
                                }
                            </Form.Item>
                            <Form.Item label="拒绝理由" {...smallFormItemLayout}>
                                <Input placeholder="拒绝理由" readOnly={readOnly}
                                    {...getFieldProps('memo', {
                                        initialValue: audit.memo
                                    })}  />
                            </Form.Item>
                            <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                {
                                    audit.status == 1 &&
                                    <span>
                                        <Button size="large" type="primary" onClick={this.handleSubmit.bind(this, 9)}>
                                            <Icon type="check-circle-o" />通过
                                        </Button>
                                        <Button size="large" type="ghost" onClick={this.handleSubmit.bind(this, 5)}
                                                style={{margin:'auto 1em' }}>
                                            <Icon type="cross-circle-o" />拒绝
                                        </Button>
                                    </span>
                                }
                                <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}>
                                    <Icon type="rollback"/>返回
                                </Button>
                            </Form.Item>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}
