import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';


import {arrayRemoveIndex, UUID, formItemLayout, smallFormItemLayout, footerFormSubmitLayout} from '../../utils';


export function YongjingTransform(arr) {
    return arr.map(item=>({
        ...item,
        key: UUID()
    }));
}

export function CreateYongjing() {
    return {key: UUID(), result: {}};
};

@Form.create()
export default class ShouyiYongjingForm extends Component {


    constructor(props, context) {
        super(props, context);

        this.state = {
            yongjing: YongjingTransform(props.product.commissionAlg)
        };
    }

    static propsType = {
        product: PropTypes.object,
        user: PropTypes.object,
        dispatch: PropTypes.func
    };

    /**
     * 添加佣金算法
     * @param e
     */
    handleAddYongjing(e) {
        e.preventDefault();
        let yongjing = [].concat(this.state.yongjing);
        yongjing.push(CreateYongjing());
        this.setState({yongjing: yongjing});
    }

    /**
     * 删除佣金算法
     * @param index
     * @param e
     */
    handleRemoveYongjin(index, e) {
        e.preventDefault();
        const yongjing = arrayRemoveIndex(this.state.yongjing, index);
        console.log(yongjing);
        this.setState({yongjing: yongjing});
    }

    handleSubmit(e) {
        e.preventDefault();
        const formData = this.props.form.getFieldsValue();

        const commissionAlg = [];
        const data = {
            id: this.props.product.id
        };
        Object.keys(formData).forEach(key=> {
            if (/^[\d]+$/g.test(key)) {
                commissionAlg.push(formData[key]);
            } else {
                data[key] = formData[key];
            }
        });
        data.commissionAlg = JSON.stringify(commissionAlg);

        console.log(data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });

    }

    render() {

        const {form:{getFieldProps}, product, loading} = this.props;

        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                    <Form.Item label="佣金结算方式" help="例如: 打款结佣、成立结佣" {...smallFormItemLayout}>
                        <Input placeholder="佣金结算方式"
                            {...getFieldProps('settlement', {
                                initialValue: product.settlement
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="产品的预期收益" help="浮动或百分比" {...smallFormItemLayout}>
                        <Input placeholder="产品的预期收益"
                            {...getFieldProps('productProspectiveReturn', {
                                initialValue: product.productProspectiveReturn
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="佣金算法" {...formItemLayout}>
                        <Input.Group>
                            <Col span="5" className="tac">最小投资额</Col>
                            <Col span="5" className="tac">最大投资额</Col>
                            <Col span="5" className="tac">收益</Col>
                            <Col span="5" className="tac">佣金</Col>
                        </Input.Group>
                        {
                            this.state.yongjing.map((item, index)=>
                                <div key={item.key}>
                                    <Input.Group>
                                        <Col span="5">
                                            <Input {...getFieldProps(index + '.min', {initialValue: item.min})} />
                                        </Col>
                                        <Col span="5">
                                            <Input {...getFieldProps(index + '.max', {initialValue: item.max})}/>
                                        </Col>
                                        <Col span="5">
                                            <Input {...getFieldProps(index + '.sy', {initialValue: item.sy})}/>
                                        </Col>
                                        <Col span="5">
                                            <Input {...getFieldProps(index + '.yj', {initialValue: item.yj})}/>
                                        </Col>
                                        <Col span="4">
                                            <Icon type="cross" onClick={this.handleRemoveYongjin.bind(this, index)}/>
                                        </Col>
                                    </Input.Group>
                                </div>
                            )
                        }
                        <Row style={{marginTop:15}}>
                            <Col span="20" className="tac">

                            </Col>
                        </Row>
                    </Form.Item>
                    <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                        <Button style={{marginRight:'1em'}}
                                onClick={this.handleAddYongjing.bind(this)}><Icon
                            type="plus"/>添加</Button>
                        <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>保存</Button>
                        {
                            !this.props.isCreate &&
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback" />返回
                            </Button>
                        }
                    </Form.Item>
                </Form>
            </Spin>
        );
    }
}

//<Button type="ghost" style={{marginLeft:'.5em'}}><Icon type="code"/>高级</Button>
//<YongjingSuanFaItem {...item} remove={this.handleRemoveYongjin.bind(this, index)}/>
