import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {arrayRemoveIndex, UUID, formItemLayout, smallFormItemLayout, footerFormSubmitLayout} from '../../utils';

@Form.create()
export default class HuikuanInfoForm extends Component {
    constructor(props, context) {
        super(props, context);
    }

    static propsType = {
        product: PropTypes.object
    };

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        const {product} = this.props;

        data.id = product.id;
        console.log('收到表单值：', data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });
    }

    render() {

        const {form:{getFieldProps}, product:{fundRaisedAccount}, loading} = this.props;

        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                    <Form.Item label="名称" help="接收打款帐户名称" {...smallFormItemLayout} >
                        <Input placeholder="名称"
                            {...getFieldProps('fundRaisedAccount.name', {
                                initialValue: fundRaisedAccount.name
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="银行帐号" help="接收打款银行帐号" {...smallFormItemLayout}>
                        <Input placeholder="银行帐号"
                            {...getFieldProps('fundRaisedAccount.number', {
                                initialValue: fundRaisedAccount.number
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="开户行" help="接收打款银行开户行" {...formItemLayout}>
                        <Input placeholder="开户行"
                            {...getFieldProps('fundRaisedAccount.bank', {
                                initialValue: fundRaisedAccount.bank
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="打款须知" help="接收打款的一些必要告知信息" {...formItemLayout}>
                        <Input type="textarea" autosize={{minRows:5, maxRows:20}} placeholder=""
                            {...getFieldProps('fundRaisedAccount.memo', {
                                initialValue: fundRaisedAccount.memo
                            })}
                        />
                    </Form.Item>
                    <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                        <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>保存</Button>
                        {
                            !this.props.isCreate &&
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback" />返回
                            </Button>
                        }
                    </Form.Item>
                </Form>
            </Spin>
        );
    }
}
