import React, {PropTypes, Component} from 'react';
import {Route, IndexRoute, Link} from 'react-router';
import App from '../containers/App/App';


export default (store)=> {
    const requireAuth = (nextState, replace, cb) => {
        const {user} = store.getState();
        if (!user || !user.token) {
            replace('/login');
        }
        cb();
    };


    return (
        <Route path="/">
            <Route onEnter={requireAuth} component={App}>
                <IndexRoute getComponents={(location, callback)=> {
                    require.ensure([], function (require) {
                        callback(null, require('../containers/Home/Home'));
                    }, 'javascript/Home');
                }}/>
                <Route path="products">
                    <IndexRoute getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Product/List'));
                        }, 'javascript/Product-List');
                    }}/>
                    <Route path="create" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Product/AddItem'));
                        }, 'javascript/Product-AddItem');
                    }}/>
                    <Route path=":id" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Product/EditItem'));
                        }, 'javascript/Product-Item');
                    }}/>
                </Route>
                <Route path="trades">
                    <IndexRoute getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Trade/List'));
                        }, 'javascript/Trade-List');
                    }}/>
                    <Route path="create" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Trade/AddItem'));
                        }, 'javascript/Trade-AddItem');
                    }}/>
                    <Route path=":id" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Trade/Item'));
                        }, 'javascript/Trade-Item');
                    }}/>
                    <Route path="commission/:id" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Trade/Commission'));
                        }, 'javascript/Trade-Commission');
                    }}/>
                    <Route path="contract/:id" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Trade/Contract'));
                        }, 'javascript/Trade-Contract');
                    }}/>
                </Route>
                <Route path="announcement">
                    <IndexRoute getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Announcement/List'));
                        }, 'javascript/Announcement-List');
                    }}/>
                    <Route path="create" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Announcement/EditItem'));
                        }, 'javascript/Announcement-Item');
                    }}/>
                    <Route path=":id" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Announcement/EditItem'));
                        }, 'javascript/Announcement-Item');
                    }}/>
                </Route>
                <Route path="remittance">
                    <Route path="audits">
                        <IndexRoute  getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Remittance/List'));
                            }, 'javascript/Remittance-List');
                        }}/>
                        <Route path=":id"  getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Remittance/PassItem'));
                            }, 'javascript/Remittance-Item');
                        }}/>
                    </Route>
                </Route>
                <Route path="withdraw">
                    <Route path="audits">
                        <IndexRoute getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Withdraw/List'));
                            }, 'javascript/Withdraw-List');
                        }}/>
                        <Route path=":id" getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Withdraw/PassItem'));
                            }, 'javascript/Withdraw-Item');
                        }}/>
                    </Route>
                </Route>
                <Route path="authInfo">
                    <Route path="audits">
                        <IndexRoute getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/AuthInfo/List'));
                            }, 'javascript/AuthInfo-List');
                        }}/>
                        <Route path=":id" getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/AuthInfo/Item'));
                            }, 'javascript/AuthInfo-Item');
                        }}/>
                    </Route>
                </Route>
                <Route path="customMessages">
                    <IndexRoute getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/CustomMessage/List'));
                        }, 'javascript/CustomMessage-List');
                    }}/>
                    <Route path="create" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/CustomMessage/AddItem'));
                        }, 'javascript/CustomMessage-AddItem');
                    }}/>
                    <Route path=":id" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/CustomMessage/Item'));
                        }, 'javascript/CustomMessage-Item');
                    }}/>
                </Route>
                <Route path="upload" getComponents={(location, callback)=> {
                    require.ensure([], function (require) {
                        callback(null, require('../containers/BaseFunction/BaseUpload'));
                    }, 'javascript/BaseFunction-BaseUpload');
                }}/>
                <Route path="admin">
                    <Route path="users">
                        <IndexRoute getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Users/List'));
                            }, 'javascript/Users-List');
                        }}/>
                        <Route path=":id" getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Users/EditItem'));
                            }, 'javascript/Users-Item');
                        }}/>
                    </Route>
                    <Route path="resources">
                        <IndexRoute getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Resource/List'));
                            }, 'javascript/Resource-List');
                        }}/>
                        <Route path=":id" getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Resource/EditItem'));
                            }, 'javascript/Resource-Item');
                        }}/>
                    </Route>
                    <Route path="authorities">
                        <IndexRoute getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Authority/List'));
                            }, 'javascript/Authority-List');
                        }}/>
                        <Route path="create" getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Authority/EditItem'));
                            }, 'javascript/Authority-Item');
                        }}/>
                        <Route path=":id" getComponents={(location, callback)=> {
                            require.ensure([], function (require) {
                                callback(null, require('../containers/Authority/EditItem'));
                            }, 'javascript/Authority-Item');
                        }}/>
                    </Route>
                </Route>
                <Route path="my">
                    <Route path="modifyPassword" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Users/ModifyPassword'));
                        }, 'javascript/Users-ModifyPassword');
                    }}/>
                    <Route path=":id" getComponents={(location, callback)=> {
                        require.ensure([], function (require) {
                            callback(null, require('../containers/Users/EditItem'));
                        }, 'javascript/Users-Item');
                    }}/>
                </Route>
            </Route>
            <Route path="/login" getComponents={(location, callback)=> {
                require.ensure(['../containers/Login/Login'], function (require) {
                    callback(null, require('../containers/Login/Login'));
                }, 'javascript/Login');
            }}/>
            <Route path="/register" getComponents={(location, callback)=> {
                require.ensure(['../containers/Users/Register'], function (require) {
                    callback(null, require('../containers/Users/Register'));
                }, 'javascript/Users-Register');
            }}/>
            <Route path="*" getComponents={(location, callback)=> {
                require.ensure(['../containers/NotFound/NotFound'], function (require) {
                    callback(null, require('../containers/NotFound/NotFound'));
                }, 'javascript/NotFound');
            }}/>
        </Route>
    );
};

