import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const remittance = handleActions({
    ['FETCH_REMITTANCE_LIST'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_REMITTANCE_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, audits: action.items, total: action.total};
    },
    ['FETCH_REMITTANCE_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false, audits: [], total: 0};
    },
    ['FETCH_REMITTANCE_ITEM'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_REMITTANCE_ITEM_SUCCESS'](state, action) {
        return {...state, loading: false, audit: action.item};
    },
    ['FETCH_REMITTANCE_ITEM_FAILED'](state, action) {
        return {...state, err: action.err, loading: false, audit: null};
    },
    ['PASS_REMITTANCE_ITEM'](state){
        return {...state, loading: true};
    },
    ['PASS_REMITTANCE_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, audit: {...state.audit, ...action.data}};
    },
    ['PASS_REMITTANCE_ITEM_FAILED'](state, action){
        return {...state, loading: false, err: action.err};
    },
    ['ZIP_SUCCESS'](state, action){
        const data = action.data;
        console.log('ZIP_SUCCESS', data);
        if (data && state.audits) {
            for (let audit of state.audits) {
                if (audit.id === data.id) {
                    audit.zip = data.url;
                    console.log('更新%s的zip%s', data.id, data.url);
                    break;
                }
            }
        }
        return {...state, zip: data};
    }
}, {
    drawMoneys: [],
    audits: [],
    loading: false,
});


export default remittance;
