import './index.html';
import React from 'react';
import ReactDOM from 'react-dom';
import {Provider} from 'react-redux';
import {createStore, applyMiddleware, compose, combineReducers} from 'redux';
import createSagaMiddleware from 'redux-saga';
import {Router, browserHistory} from 'react-router';
import {syncHistoryWithStore, routerReducer as routing} from 'react-router-redux';
import reducers from '../reducers/index';
import {ReduxAsyncConnect} from 'redux-async-connect';
import SagaManager from '../sagas/SagaManager';
import './index.less';

import Button from 'antd/lib/button';
import Icon from 'antd/lib/icon';
import Row from 'antd/lib/row';
import Col from 'antd/lib/col';
import Form from 'antd/lib/form';
import Checkbox from 'antd/lib/checkbox';
import message from 'antd/lib/message';
import Tabs from 'antd/lib/tabs';
import Spin from 'antd/lib/spin';
import Table from 'antd/lib/table';
import DatePicker from 'antd/lib/date-picker';
import Modal from 'antd/lib/modal';
import Upload from 'antd/lib/upload';
import Radio from 'antd/lib/radio';
import Cascader from 'antd/lib/cascader';


//////////////////////
// Store

const sagaMiddleware = createSagaMiddleware();
const initialState = {};
const enhancer = compose(
    applyMiddleware(sagaMiddleware),
    window.devToolsExtension ? window.devToolsExtension() : f => f
);
const store = createStore(combineReducers({
    ...reducers, routing,
}), initialState, enhancer);
SagaManager.startSagas(sagaMiddleware);

if (module.hot) {
    module.hot.accept('../reducers', () => {
        const reducers = require('../reducers');
        const combinedReducers = combineReducers({...reducers, routing});
        store.replaceReducer(combinedReducers);
    });
    module.hot.accept('../sagas/SagaManager', () => {
        SagaManager.cancelSagas(store);
        require('../sagas/SagaManager').default.startSagas(sagaMiddleware);
    });
}

//////////////////////
// Render

const history = syncHistoryWithStore(browserHistory, store);

let render = () => {
    const getRoutes = require('../routes/index');
    ReactDOM.render(
        <Provider store={store}>
            <Router history={history}>
                {getRoutes(store)}
            </Router>
        </Provider>
        , document.getElementById('root'));
};

if (module.hot) {
    const renderNormally = render;
    const renderException = (error) => {
        const RedBox = require('redbox-react');
        ReactDOM.render(<RedBox error={error}/>, document.getElementById('root'));
    };
    render = () => {
        try {
            renderNormally();
        } catch (error) {
            console.error('error', error);
            renderException(error);
        }
    };
    module.hot.accept('../routes/index', () => {
        render();
    });
}

render();
