import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin,
    Breadcrumb
} from 'antd';

import * as ProductForm from '../../components/ProductForm/index';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';
import MainHeader from '../../components/MainHeader/MainHeader';
import Layout from '../../components/Layout/Layout';


@connect(state=>({
    cates: state.product.cates,
    product: state.product.item,
    loading: state.product.loading,
    user: state.user,
    isEdit: state.product.isEdit
}))
export default class EditItem extends Component {

    static propTypes = {
        form: PropTypes.object,
        dispatch: PropTypes.func,
        caste: PropTypes.array,
        product: PropTypes.object
    };

    constructor(props, content) {
        super(props, content);
    }


    componentDidMount() {
        if (!(this.props.cates && this.props.cates.length)) {
            this.fetchCates();
        }
        this.fetchItem(this.props.params.id);
    };

    fetchCates() {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_CATES'
        });
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_ITEM',
            id
        });
    };


    render = ()=> {

        const {product, isEdit, params, dispatch} = this.props;

        const styles = require('./Product.less');

        const tabs = [
            {tab: '基本信息', children: ProductForm.BaseInfoForm},
            {tab: '收益佣金', children: ProductForm.ShouyiYongjingForm},
            {tab: '汇款账号', children: ProductForm.HuikuanInfoForm},
            {tab: '基本要素', children: ProductForm.ElementForm},
            {tab: '时间状态', children: ProductForm.DateTimeStatusForm},
            {tab: '相关附件', children: ProductForm.DocumentsForm},
            {tab: '服务经理', children: ProductForm.ContactForm}
        ].map((tabPane, index)=> {
            tabPane.key = 'tabs-pane-' + (index + 1);
            return tabPane;
        });

        const title = (product && product.itemShortTitle ? product.itemShortTitle + ' - ' : '') + '产品详情' + (isEdit ? ' - 编辑中' : '');


        const operation = (
            <HeaderOperation history={this.props.history}
                             buttons={product && DetailOperations('PRODUCT', params.id, isEdit, dispatch)}/>
        );

        const header = (
            <MainHeader breadcrumb={['产品管理', '产品详情']}
                        title={title}
                        operation={operation}
            />
        );


        return (
            <Layout header={header}>
                <Tabs className={styles.tabs} tabPosition="left">
                    { tabs.map(tp=>
                        <Tabs.TabPane tab={tp.tab} key={tp.key}>
                            {product && <tp.children {...this.props} isEdit={isEdit}/> }
                        </Tabs.TabPane>
                    )}
                </Tabs>
            </Layout>
        );
    }
}
