// export const params = query => Object.keys(query).map((key)=> {
//     return key + '=' + query[key];
// }).join('&');

export const NULL = '_____?_____';

export function serialize(obj, prefix) {
    var str = [];
    Object.keys(obj).map(p=> {
        let v = obj[p];
        if (p && typeof v !== 'undefined') {
            let k = prefix ? prefix + "." + p : p;
            if (typeof v == 'object') {
                v = serialize(v, k);
                if (v) {
                    str.push(v);
                }
            } else {
                str.push(encodeURIComponent(k) + "=" + encodeURIComponent(v));
            }
        }
    });
    return str.length ? str.join("&") : '';
}


export const leftPad = num => {
    return num >= 10 ? num : ('0' + num);
};

export const formatDateTime = (time = 0, format = 'YYYY-MM-DD hh:mm:ss') => {
    const date = new Date(time);
    const data = {
        YYYY: date.getFullYear(),
        MM: leftPad(date.getMonth() + 1),
        DD: leftPad(date.getDate()),
        hh: leftPad(date.getHours()),
        mm: leftPad(date.getMinutes()),
        ss: leftPad(date.getSeconds())
    };
    return format.replace(/[A-Za-z]+/g, metch => {
        return data[metch];
    });
};

export const PRODUCT_STATUS = {
    '-9': '草稿',
    0: '已删除',
    1: '未发布',
    5: '预热中',
    11: '募集中',
    17: '已暂停',
    21: '已封账',
    31: '已成立',
}

export const productStatusToString = status => {
    return PRODUCT_STATUS[status] || '未定义';
};

export const productEnableCreateTrade = status => {
    return status > 1 && status <= 21;
};

export const USER_STATUS = {
    0: '未激活',
    1: '正常'
};

export const userStatusToString = status => {
    return USER_STATUS[status] || '未定义';
};


export const tradeStatusToString = status => {
    switch (status) {
        case 1  :
            return '未报单';
        case 10:
            return '待验资';
        case 11:
            return '验资成功，待成立';
        case 16:
            return '验资失败，资金未到账';
        case 12:
            return '产品待成立';
        case 21:
            return '产品已成立';
        case 22:
            return '产品已成立';
        case 31:
            return '交易关闭';
        case 32:
            return '交易关闭';
        case 33:
            return '交易关闭';
        default:
            return '未定义';
    }
};

export const tradeCreateTypeToString = type => {
    switch (type) {
        case 1:
            return 'APP创建';
        case 5:
            return '后台创建';
        default:
            return '未知创建者';
    }
};

export const arrayRemoveIndex = (arr, index) => {
    return arr.concat(arr.splice(index).splice(1));
};

export const UUID = (()=> {
    let _UUID = 0;
    return ()=> {
        return _UUID++;
    }
})();

export function formatMoney(money = 0) {
    let ret;
    if (isNaN(money)) {
        ret = '0';
    } else if (money >= 1E10) {
        ret = (money / 1E10) + '亿';
    } else if (money >= 1E6) {
        ret = (money / 1E6) + '万';
    } else {
        ret = (money / 1E2);
    }
    return ret;
}


export const formItemLayout = {
    labelCol: {span: 4},
    wrapperCol: {span: 16},
};
export const leftRightFormItemLayout = {
    labelCol: {span: 6},
    wrapperCol: {span: 16}
};

export const smallFormItemLayout = {
    labelCol: {span: 4},
    wrapperCol: {span: 10}
};

export const footerFormSubmitLayout = {
    wrapperCol: {span: 16, offset: 4}
};

export const filterFormItemLayout = {
    labelCol: {span: 10},
    wrapperCol: {span: 14}
};

export const filterFormItemStyle = {
    size: 'default',
    style: {width: 100}
};


export function filterUploadSuccess(fileList) {
    return fileList.filter((file) => {
        if (file.response) {
            return file.response.status === 1;
        }
        return true;
    });
}

export function transformUploadThumbUrl(fileList) {
    return fileList.map((file) => {
        if (file.response) {
            // 组件会将 file.url 作为链接进行展示
            //file.url = file.response.url;
            const {result, status, message} = file.response;
            if (status === 1 && result && result.length >= 1 && result[0].url) {
                file.url = result[0].url;
                file.thumbUrl = result[0].url + '!t';
            }
            return {
                uid: file.uid,
                status: file.status,
                type: file.type,
                url: file.url,
                thumbUrl: file.thumbUrl,
                name: file.name,
                size: file.size
            }
        }
        return file;
    });
}

export function handleUpload(info, limit) {
    let fileList = filterUploadSuccess(info.fileList);
    if (limit) {
        fileList = fileList.slice(-1 * limit);
    }
    return transformUploadThumbUrl(fileList);
}


export function remittanceAuditStatusToString(status) {
    switch (status) {
        case 0:
            return '已删除';
        case 1:
            return '待审核';
        case 5:
            return '审核失败';
        case 9:
            return '审核成功';
        default:
            return '未定义';
    }
}

export function mobileSecrecy(mobile){
    return (mobile+'').replace(/^(\d{3})(\d{4})(\d{4})$/g, (b,c,d,e)=>(c+'****'+e));
}
