import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const initState = {
    items: [],
    loading: false,
};

const announcement = handleActions({
    ['INIT_ANNOUNCEMENT'](){
          return initState;
    },
    ['FETCH_ANNOUNCEMENT_LIST'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_ANNOUNCEMENT_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, items: action.items, total: action.total};
    },
    ['FETCH_ANNOUNCEMENT_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false};
    },
    ['FETCH_ANNOUNCEMENT_ITEM'](state){
        return {...state, loading: true}
    },
    ['FETCH_ANNOUNCEMENT_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: action.item}
    },
    ['FETCH_ANNOUNCEMENT_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false}
    },
    ['CREATE_ANNOUNCEMENT_ITEM'](state){
        return {...state, loading: true}
    },
    ['CREATE_ANNOUNCEMENT_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: action.item}
    },
    ['CREATE_ANNOUNCEMENT_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false}
    },
    ['UPDATE_ANNOUNCEMENT_ITEM'](state){
        return {...state, loading: true}
    },
    ['UPDATE_ANNOUNCEMENT_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: {...state.item, ...action.item}}
    },
    ['UPDATE_ANNOUNCEMENT_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false}
    },
}, initState);

export default announcement;
