import {takeLatest} from 'redux-saga';
import {take, call, put, fork, cancel, select} from 'redux-saga/effects';
import {fetchAuditList, fetchAuditItem} from '../services/remittance';
import {message} from 'antd';

function* getAuditList(query) {
    try {
        const {total, audits} = yield call(fetchAuditList, query);
        yield put({
            type: 'FETCH_AUDIT_LIST_SUCCESS',
            total,
            items: audits
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_AUDIT_LIST_FAILED',
            err,
        });
    }
}

function* watchAuditList() {
    while (true) {
        const {query} = yield take('FETCH_AUDIT_LIST');
        yield fork(getAuditList, query);
    }
}

function* getAuditItem(id) {
    try {
        const item = yield call(fetchAuditItem, id);
        yield put({
            type: 'FETCH_AUDIT_ITEM_SUCCESS',
            item
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_AUDIT_ITEM_FAILED',
            err
        });
    }
}

function* watchAuditItem() {
    while (true) {
        const {id} = yield take('FETCH_AUDIT_ITEM');
        yield fork(getAuditItem, id);
    }
}

export default function*() {
    yield fork(watchAuditList);
    yield fork(watchAuditItem);
    // yield fork(watchAdd);
    // yield fork(watchEdit);
}
