import React, {PropTypes, Component} from 'react';
import {Route, IndexRoute, Link} from 'react-router';
import {
    Home,
    NotFound,
    Login,
    App,
    ProductList,
    ProductAddItem,
    ProductEditItem,
    TradeList,
    TradeItem,
    Commission,
    Contract,
    TradeAddItem,
    AnnouncementList,
    AnnouncementEditItem,
    AnnouncementAddItem,
    RemittanceAuditList ,
} from '../containers/index';

export default (store)=> {
    const requireAuth = (nextState, replace, cb) => {
        const {user} = store.getState();
        if (!user || !user.token) {
            replace('/login');
        }
        cb();
    };
    return (
        <Route path="/">
            <Route onEnter={requireAuth} component={App}>
                <IndexRoute component={Home}/>
                <Route path="products">
                    <IndexRoute component={ProductList}/>
                    <Route path="create" component={ProductAddItem}/>
                    <Route path=":id" component={ProductEditItem}/>
                </Route>
                <Route path="trades">
                    <IndexRoute component={TradeList}/>
                    <Route path="create" component={TradeAddItem}/>
                    <Route path=":id" component={TradeItem}/>
                    <Route path="commission/:id" component={Commission}/>
                    <Route path="contract/:id" component={Contract}/>
                </Route>
                <Route path="announcement">
                    <IndexRoute component={AnnouncementList}/>
                    <Route path="create" component={AnnouncementAddItem}/>
                    <Route path=":id/edit" component={AnnouncementEditItem}/>
                </Route>
                <Route path="remittance">
                    <Route path="audits">
                        <IndexRoute component={RemittanceAuditList} />
                    </Route>
                </Route>
                <Route path="/actived" component={Home}/>
                <Route path="/completed" component={Home}/>
            </Route>
            <Route path="/login" component={Login}/>
            <Route path="*" component={NotFound}/>
        </Route>
    );
};

//
