import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const audit = handleActions({
    ['FETCH_AUDIT_LIST'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_AUDIT_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, audits: action.items, total: action.total};
    },
    ['FETCH_AUDIT_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false};
    },
    ['FETCH_AUDIT_ITEM'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_AUDIT_ITEM_SUCCESS'](state, action) {
        return {...state, loading: false, audit: action.item};
    },
    ['FETCH_AUDIT_ITEM_FAILED'](state, action) {
        return {...state, err: action.err, loading: false};
    },
}, {
    audits: [],
    loading: false,
});


export default audit;
