import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader';

import {formItemLayout, footerFormSubmitLayout} from '../../utils';

@connect(state=>({
    loading: state.remittance.loading,
    audit: state.remittance.audit,
}))
@Form.create()
export default class EditItem extends Component {
    constructor() {
        super(...arguments);
    }


    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_AUDIT_ITEM',
            id
        });
    };

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.id = this.props.audit.id;
        console.log(data);
        // this.props.dispatch({
        //     type: 'UPDATE_AUDIT_ITEM',
        //     data
        // });
    }

    render() {
        const {audit, loading, form:{getFieldProps}, location:{query}} = this.props;

        const header = (<MainHeader breadcrumb={['审核管理', '报单审核','审核详情']}
                                    title={(audit && audit.title ? audit.title + ' - ' : '') + '审核详情'}/>);

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        audit &&
                        <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                            <Form.Item label="产品募集情况" {...formItemLayout}>
                                <Input placeholder="公告标题"
                                    {...getFieldProps('title', {
                                        initialValue: audit.title
                                    })}  />
                            </Form.Item>
                            <Form.Item label="内容" {...formItemLayout}>
                                <Input placeholder="公告内容" autosize={{ minRows: 5 }} type="textarea"
                                    {...getFieldProps('announcement', {
                                        initialValue: audit.announcement
                                    })}  />
                            </Form.Item>
                            <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                <Button type="primary" htmlType="submit" loading={loading}><Icon
                                    type="save"/>修改</Button>
                                <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                        style={{marginLeft:'1em'}}>
                                    <Icon type="rollback"/>返回
                                </Button>
                            </Form.Item>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}
