import React, {Component, PropTypes} from 'react';
import {Router, Route, IndexRoute, Link} from 'react-router';
import Layout from '../../components/Layout/Layout';


import {Collapse, Menu, Icon} from 'antd';
const Panel = Collapse.Panel;

const SubMenu = Menu.SubMenu;
const MenuItemGroup = Menu.ItemGroup;


export default class App extends Component {
    static propTypes = {
        children: PropTypes.object.isRequired,
    };

    static contextTypes = {
        store: PropTypes.object.isRequired
    };

    render() {
        const styles = require('./App.less');
        const mainMenu = [
            {
                title: '产品管理',
                items: [
                    {
                        to: '/products',
                        cn: '产品列表',
                        en: 'Products'
                    }, {
                        to: '/products/create',
                        cn: '添加产品',
                        en: 'Add Products'
                    }
                ]
            }, {
                title: '订单管理',
                items: [
                    {
                        to: '/trades',
                        cn: '订单列表',
                        en: 'Trades'
                    }
                ]
            }, {
                title: '审核管理',
                items: [
                    {
                        to: '/remittance/audits',
                        cn: '报单审核',
                        en: 'Remittance Audits'
                    }
                ]
            }
        ];
        const logo = require('./images/logo.png');
        return (
            <div className={styles.normal}>
                <div className={styles.head}>
                    <img className="page-logo" src={'/'+logo} title="枢纽科技" alt="枢纽科技"/>
                </div>
                <div className={styles.content}>
                    <div className={styles.side}>
                        <Menu mode="inline" defaultOpenKeys={['sub1']}>
                            <SubMenu key="sub1" title={<span><Icon type="mail" /><span>业务管理</span></span>}>
                                {
                                    mainMenu.map((menu, mi)=>
                                        <MenuItemGroup title={menu.title} key={mi}>
                                            {
                                                menu.items.map((item, ii)=>
                                                    <Menu.Item key={[mi,ii].join('-')}>
                                                        <MenuItemContent {...item}/>
                                                    </Menu.Item>
                                                )
                                            }
                                        </MenuItemGroup>
                                    )
                                }
                            </SubMenu>
                        </Menu>
                    </div>
                    <div className={styles.main}>
                        {this.props.children}
                    </div>
                </div>
                <div className={styles.foot}>
                    杭州枢纽科技有限公司 荣誉出品 <a href="mailto:bainx@vip.qq.com">问题反馈</a>
                </div>
            </div>
        );
    }
}

class MenuItemContent extends Component {
    static propType = {
        to: PropTypes.string,
        cn: PropTypes.string,
        en: PropTypes.string,
    }

    render() {
        const {to, cn, en} = this.props;
        return (
            <Link to={to}>
                <span>
                    <span className="cn">{cn}</span>
                    <span className="en">{en}</span>
                </span>
            </Link>
        );
    }
}




















