import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {
    PRODUCT_STATUS,
    formatDateTime,
    arrayRemoveIndex,
    UUID,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout
} from '../../utils';

const ProductStatus = Object.keys(PRODUCT_STATUS).filter(key=>key != -9);


@Form.create()
export default class DateTimeSatausForm extends Component {

    constructor(props, context) {
        super(props, context);
    }

    handleSubmit(e) {
        e.preventDefault();
        const formData = this.props.form.getFieldsValue();

        const data = {
            id: this.props.product.id
        };
        if (formData.fundReservationStartTime) {
            data.fundReservationStartTime = formatDateTime(formData.fundReservationStartTime);
        }
        if (formData.fundRaisedStartTime[0]) {
            data.fundRaisedStartTime = formatDateTime(formData.fundRaisedStartTime[0]);
        }
        if (formData.fundRaisedStartTime[1]) {
            data.fundRaisedEndTime = formatDateTime(formData.fundRaisedStartTime[0])
        }
        if (formData.remittanceEndTime) {
            data.remittanceEndTime = formatDateTime(formData.remittanceEndTime);
        }
        if (formData.fundEstablishedTime[0]) {
            data.fundEstablishedTime = formatDateTime(formData.fundEstablishedTime[0]);
        }
        if (formData.fundEstablishedTime[1]) {
            data.fundExpireTime = formatDateTime(formData.fundEstablishedTime[1]);
        }

        data.status = formData.status;

        console.log(data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });
    }

    render() {

        const {product, loading, form:{getFieldProps}, isCreate} = this.props;
        const {
            fundReservationStartTime,
            fundRaisedEndTime,
            remittanceEndTime,
            fundEstablishedTime,
            fundExpireTime
        } = product;


        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                    {
                        !isCreate &&
                        <Form.Item label="产品状态" {...formItemLayout} wrapperCol={{span:20}}>
                            <Radio.Group {...getFieldProps('status', {initialValue: product.status + ''})}>
                                {
                                    ProductStatus.map((status, index)=>
                                        <Radio.Button key={status} data-value={status}
                                                      value={status}>{PRODUCT_STATUS[status]}</Radio.Button>
                                    )
                                }
                            </Radio.Group>
                        </Form.Item>
                    }
                    <Form.Item label="预约开始时间" {...formItemLayout}>
                        <DatePicker showTime format="yyyy-MM-dd HH:mm:ss" placeholder="请选择预约开始时间"
                            {...getFieldProps('fundReservationStartTime', {
                                initialValue: fundReservationStartTime ? formatDateTime(fundReservationStartTime) : ''
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="募集开始与结束时间" {...formItemLayout}>
                        <DatePicker.RangePicker showTime format="yyyy-MM-dd HH:mm:ss"
                            {...getFieldProps('fundRaisedStartTime', {
                                initialValue: [
                                    fundReservationStartTime ? formatDateTime(fundReservationStartTime) : '',
                                    fundRaisedEndTime ? formatDateTime(fundRaisedEndTime) : ''
                                ]
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="汇款结束时间" {...formItemLayout}>
                        <DatePicker showTime format="yyyy-MM-dd HH:mm:ss" placeholder="请选择汇款结束时间"
                            {...getFieldProps('remittanceEndTime', {
                                initialValue: remittanceEndTime ? formatDateTime(remittanceEndTime) : ''
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="基金成立与到期时间" {...formItemLayout}>
                        <DatePicker.RangePicker showTime format="yyyy-MM-dd HH:mm:ss"
                            {...getFieldProps('fundEstablishedTime', {
                                initialValue: [
                                    fundEstablishedTime ? formatDateTime(fundEstablishedTime) : '',
                                    fundExpireTime ? formatDateTime(fundExpireTime) : ''
                                ]
                            })}
                        />
                    </Form.Item>
                    <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                        <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>保存</Button>
                        {
                            !this.props.isCreate &&
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback" />返回
                            </Button>
                        }
                    </Form.Item>
                </Form>
            </Spin>
        );
    }
}
