import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {arrayRemoveIndex, UUID, formItemLayout, smallFormItemLayout, footerFormSubmitLayout} from '../../utils';


@Form.create()
export default class ContactForm extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            staffs: props.product.staffs.map(staffs=> {
                staffs.key = UUID();
                return staffs;
            })
        };

    }

    static propsType = {
        product: PropTypes.object,
    };

    /**
     * 删除基本要素
     * @param index
     * @param e
     */
    handleRemove(index, e) {
        e.preventDefault();
        const staffs = arrayRemoveIndex(this.state.staffs, index);
        this.setState({staffs: staffs});
    }

    /**
     * 添加基本要素
     * @param e
     */
    handleAdd(e) {
        e.preventDefault();
        let staffs = [].concat(this.state.staffs);
        staffs.push({key: UUID()});

        this.setState({staffs});
    }

    handleSubmit(e) {
        e.preventDefault();
        const formData = this.props.form.getFieldsValue();
        const tmp = Object.keys(formData).map(index=> {
            return {
                ...formData[index]
            }
        }).filter(item=>item.name && item.mobile);
        const data = {
            id: this.props.product.id,
            staffs: JSON.stringify(tmp)
        }

        console.log('收到表单值：', data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });


    }

    render() {
        const {form:{getFieldProps}, loading}  = this.props;
        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                    <Form.Item>
                        {
                            this.state.staffs.map((item, index)=>
                                <div key={item.key} style={{marginBottom:8}}>
                                    <Input.Group>
                                        <Col span="6">
                                            <Input placeholder="姓名"
                                                {...getFieldProps(index + '.name', {
                                                    initialValue: item.name
                                                })} />
                                        </Col>
                                        <Col span="10">
                                            <Input placeholder="电话"
                                                {...getFieldProps(index + '.mobile', {
                                                    initialValue: item.mobile
                                                })}/>
                                        </Col>
                                        <Col span="4">
                                            <Icon type="cross" title="删除" onClick={this.handleRemove.bind(this, index)}/>
                                        </Col>
                                    </Input.Group>
                                </div>
                            )
                        }
                    </Form.Item>
                    <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                        <Button onClick={this.handleAdd.bind(this)} style={{marginRight:'1em'}}><Icon
                            type="plus"/>添加</Button>
                        <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>保存</Button>
                        {
                            !this.props.isCreate &&
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback" />返回
                            </Button>
                        }
                    </Form.Item>
                </Form>
            </Spin>
        );
    }
}
